<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PaymentMethodType EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentMethodType
 * @subpackage Enumerations
 */
class PaymentMethodType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Cash'
     * @return string 'Cash'
     */
    const VALUE_CASH = 'Cash';
    /**
     * Constant for value 'CreditCard'
     * @return string 'CreditCard'
     */
    const VALUE_CREDIT_CARD = 'CreditCard';
    /**
     * Constant for value 'Refund'
     * @return string 'Refund'
     */
    const VALUE_REFUND = 'Refund';
    /**
     * Constant for value 'Settlement'
     * @return string 'Settlement'
     */
    const VALUE_SETTLEMENT = 'Settlement';
    /**
     * Constant for value 'OnlinePayment'
     * @return string 'OnlinePayment'
     */
    const VALUE_ONLINE_PAYMENT = 'OnlinePayment';
    /**
     * Constant for value 'Reservation'
     * @return string 'Reservation'
     */
    const VALUE_RESERVATION = 'Reservation';
    /**
     * Constant for value 'GiftVoucher'
     * @return string 'GiftVoucher'
     */
    const VALUE_GIFT_VOUCHER = 'GiftVoucher';
    /**
     * Constant for value 'DirectDebit'
     * @return string 'DirectDebit'
     */
    const VALUE_DIRECT_DEBIT = 'DirectDebit';
    /**
     * Constant for value 'Coupon'
     * @return string 'Coupon'
     */
    const VALUE_COUPON = 'Coupon';
    /**
     * Constant for value 'BankTransfer'
     * @return string 'BankTransfer'
     */
    const VALUE_BANK_TRANSFER = 'BankTransfer';
    /**
     * Constant for value 'DebitCard'
     * @return string 'DebitCard'
     */
    const VALUE_DEBIT_CARD = 'DebitCard';
    /**
     * Constant for value 'Cheque'
     * @return string 'Cheque'
     */
    const VALUE_CHEQUE = 'Cheque';
    /**
     * Constant for value 'WithdrawDeposit'
     * @return string 'WithdrawDeposit'
     */
    const VALUE_WITHDRAW_DEPOSIT = 'WithdrawDeposit';
    /**
     * Constant for value 'TradeIn'
     * @return string 'TradeIn'
     */
    const VALUE_TRADE_IN = 'TradeIn';
    /**
     * Constant for value 'UnionSubsidy'
     * @return string 'UnionSubsidy'
     */
    const VALUE_UNION_SUBSIDY = 'UnionSubsidy';
    /**
     * Constant for value 'GiftCard'
     * @return string 'GiftCard'
     */
    const VALUE_GIFT_CARD = 'GiftCard';
    /**
     * Constant for value 'LoyaltyPoints'
     * @return string 'LoyaltyPoints'
     */
    const VALUE_LOYALTY_POINTS = 'LoyaltyPoints';
    /**
     * Constant for value 'PaymentPlan'
     * @return string 'PaymentPlan'
     */
    const VALUE_PAYMENT_PLAN = 'PaymentPlan';
    /**
     * Constant for value 'Custom'
     * @return string 'Custom'
     */
    const VALUE_CUSTOM = 'Custom';
    /**
     * Return allowed values
     * @uses self::VALUE_CASH
     * @uses self::VALUE_CREDIT_CARD
     * @uses self::VALUE_REFUND
     * @uses self::VALUE_SETTLEMENT
     * @uses self::VALUE_ONLINE_PAYMENT
     * @uses self::VALUE_RESERVATION
     * @uses self::VALUE_GIFT_VOUCHER
     * @uses self::VALUE_DIRECT_DEBIT
     * @uses self::VALUE_COUPON
     * @uses self::VALUE_BANK_TRANSFER
     * @uses self::VALUE_DEBIT_CARD
     * @uses self::VALUE_CHEQUE
     * @uses self::VALUE_WITHDRAW_DEPOSIT
     * @uses self::VALUE_TRADE_IN
     * @uses self::VALUE_UNION_SUBSIDY
     * @uses self::VALUE_GIFT_CARD
     * @uses self::VALUE_LOYALTY_POINTS
     * @uses self::VALUE_PAYMENT_PLAN
     * @uses self::VALUE_CUSTOM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CASH,
            self::VALUE_CREDIT_CARD,
            self::VALUE_REFUND,
            self::VALUE_SETTLEMENT,
            self::VALUE_ONLINE_PAYMENT,
            self::VALUE_RESERVATION,
            self::VALUE_GIFT_VOUCHER,
            self::VALUE_DIRECT_DEBIT,
            self::VALUE_COUPON,
            self::VALUE_BANK_TRANSFER,
            self::VALUE_DEBIT_CARD,
            self::VALUE_CHEQUE,
            self::VALUE_WITHDRAW_DEPOSIT,
            self::VALUE_TRADE_IN,
            self::VALUE_UNION_SUBSIDY,
            self::VALUE_GIFT_CARD,
            self::VALUE_LOYALTY_POINTS,
            self::VALUE_PAYMENT_PLAN,
            self::VALUE_CUSTOM,
        );
    }
}
