<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for InboundPaymentFileItemStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InboundPaymentFileItemStatus
 * @subpackage Enumerations
 */
class InboundPaymentFileItemStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NotProcessed'
     * @return string 'NotProcessed'
     */
    const VALUE_NOT_PROCESSED = 'NotProcessed';
    /**
     * Constant for value 'Processed'
     * @return string 'Processed'
     */
    const VALUE_PROCESSED = 'Processed';
    /**
     * Constant for value 'ProcessingError'
     * @return string 'ProcessingError'
     */
    const VALUE_PROCESSING_ERROR = 'ProcessingError';
    /**
     * Constant for value 'ParsingError'
     * @return string 'ParsingError'
     */
    const VALUE_PARSING_ERROR = 'ParsingError';
    /**
     * Constant for value 'Ignored'
     * @return string 'Ignored'
     */
    const VALUE_IGNORED = 'Ignored';
    /**
     * Constant for value 'AlreadyProcessed'
     * @return string 'AlreadyProcessed'
     */
    const VALUE_ALREADY_PROCESSED = 'AlreadyProcessed';
    /**
     * Constant for value 'AlreadyPaid'
     * @return string 'AlreadyPaid'
     */
    const VALUE_ALREADY_PAID = 'AlreadyPaid';
    /**
     * Constant for value 'AmountToHigh'
     * @return string 'AmountToHigh'
     */
    const VALUE_AMOUNT_TO_HIGH = 'AmountToHigh';
    /**
     * Constant for value 'AmountToLow'
     * @return string 'AmountToLow'
     */
    const VALUE_AMOUNT_TO_LOW = 'AmountToLow';
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_PROCESSED
     * @uses self::VALUE_PROCESSED
     * @uses self::VALUE_PROCESSING_ERROR
     * @uses self::VALUE_PARSING_ERROR
     * @uses self::VALUE_IGNORED
     * @uses self::VALUE_ALREADY_PROCESSED
     * @uses self::VALUE_ALREADY_PAID
     * @uses self::VALUE_AMOUNT_TO_HIGH
     * @uses self::VALUE_AMOUNT_TO_LOW
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_PROCESSED,
            self::VALUE_PROCESSED,
            self::VALUE_PROCESSING_ERROR,
            self::VALUE_PARSING_ERROR,
            self::VALUE_IGNORED,
            self::VALUE_ALREADY_PROCESSED,
            self::VALUE_ALREADY_PAID,
            self::VALUE_AMOUNT_TO_HIGH,
            self::VALUE_AMOUNT_TO_LOW,
        );
    }
}
