<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for BatchExecutionState EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BatchExecutionState
 * @subpackage Enumerations
 */
class BatchExecutionState extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NotRunning'
     * @return string 'NotRunning'
     */
    const VALUE_NOT_RUNNING = 'NotRunning';
    /**
     * Constant for value 'InProgress'
     * @return string 'InProgress'
     */
    const VALUE_IN_PROGRESS = 'InProgress';
    /**
     * Constant for value 'Completed'
     * @return string 'Completed'
     */
    const VALUE_COMPLETED = 'Completed';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_RUNNING
     * @uses self::VALUE_IN_PROGRESS
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_RUNNING,
            self::VALUE_IN_PROGRESS,
            self::VALUE_COMPLETED,
            self::VALUE_ERROR,
        );
    }
}
