<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfResultPartMetadata ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfResultPartMetadata
 * @subpackage Arrays
 */
class ArrayOfResultPartMetadata extends AbstractStructArrayBase
{
    /**
     * The ResultPartMetadata
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ResultPartMetadata[]
     */
    public $ResultPartMetadata;
    /**
     * Constructor method for ArrayOfResultPartMetadata
     * @uses ArrayOfResultPartMetadata::setResultPartMetadata()
     * @param \patest\StructType\ResultPartMetadata[] $resultPartMetadata
     */
    public function __construct(array $resultPartMetadata = array())
    {
        $this
            ->setResultPartMetadata($resultPartMetadata);
    }
    /**
     * Get ResultPartMetadata value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ResultPartMetadata[]|null
     */
    public function getResultPartMetadata()
    {
        return isset($this->ResultPartMetadata) ? $this->ResultPartMetadata : null;
    }
    /**
     * This method is responsible for validating the values passed to the setResultPartMetadata method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResultPartMetadata method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResultPartMetadataForArrayConstraintsFromSetResultPartMetadata(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfResultPartMetadataResultPartMetadataItem) {
            // validation for constraint: itemType
            if (!$arrayOfResultPartMetadataResultPartMetadataItem instanceof \patest\StructType\ResultPartMetadata) {
                $invalidValues[] = is_object($arrayOfResultPartMetadataResultPartMetadataItem) ? get_class($arrayOfResultPartMetadataResultPartMetadataItem) : sprintf('%s(%s)', gettype($arrayOfResultPartMetadataResultPartMetadataItem), var_export($arrayOfResultPartMetadataResultPartMetadataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ResultPartMetadata property can only contain items of type \patest\StructType\ResultPartMetadata, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ResultPartMetadata value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ResultPartMetadata[] $resultPartMetadata
     * @return \patest\ArrayType\ArrayOfResultPartMetadata
     */
    public function setResultPartMetadata(array $resultPartMetadata = array())
    {
        // validation for constraint: array
        if ('' !== ($resultPartMetadataArrayErrorMessage = self::validateResultPartMetadataForArrayConstraintsFromSetResultPartMetadata($resultPartMetadata))) {
            throw new \InvalidArgumentException($resultPartMetadataArrayErrorMessage, __LINE__);
        }
        if (is_null($resultPartMetadata) || (is_array($resultPartMetadata) && empty($resultPartMetadata))) {
            unset($this->ResultPartMetadata);
        } else {
            $this->ResultPartMetadata = $resultPartMetadata;
        }
        return $this;
    }
    /**
     * Add item to ResultPartMetadata value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ResultPartMetadata $item
     * @return \patest\ArrayType\ArrayOfResultPartMetadata
     */
    public function addToResultPartMetadata(\patest\StructType\ResultPartMetadata $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\ResultPartMetadata) {
            throw new \InvalidArgumentException(sprintf('The ResultPartMetadata property can only contain items of type \patest\StructType\ResultPartMetadata, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ResultPartMetadata[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\ResultPartMetadata|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\ResultPartMetadata|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\ResultPartMetadata|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\ResultPartMetadata|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\ResultPartMetadata|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ResultPartMetadata
     */
    public function getAttributeName()
    {
        return 'ResultPartMetadata';
    }
}
