<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEntityIdentity ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfEntityIdentity
 * @subpackage Arrays
 */
class ArrayOfEntityIdentity extends AbstractStructArrayBase
{
    /**
     * The EntityIdentity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EntityIdentity[]
     */
    public $EntityIdentity;
    /**
     * Constructor method for ArrayOfEntityIdentity
     * @uses ArrayOfEntityIdentity::setEntityIdentity()
     * @param \patest\StructType\EntityIdentity[] $entityIdentity
     */
    public function __construct(array $entityIdentity = array())
    {
        $this
            ->setEntityIdentity($entityIdentity);
    }
    /**
     * Get EntityIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EntityIdentity[]|null
     */
    public function getEntityIdentity()
    {
        return isset($this->EntityIdentity) ? $this->EntityIdentity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEntityIdentity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEntityIdentity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEntityIdentityForArrayConstraintsFromSetEntityIdentity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEntityIdentityEntityIdentityItem) {
            // validation for constraint: itemType
            if (!$arrayOfEntityIdentityEntityIdentityItem instanceof \patest\StructType\EntityIdentity) {
                $invalidValues[] = is_object($arrayOfEntityIdentityEntityIdentityItem) ? get_class($arrayOfEntityIdentityEntityIdentityItem) : sprintf('%s(%s)', gettype($arrayOfEntityIdentityEntityIdentityItem), var_export($arrayOfEntityIdentityEntityIdentityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EntityIdentity property can only contain items of type \patest\StructType\EntityIdentity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EntityIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\EntityIdentity[] $entityIdentity
     * @return \patest\ArrayType\ArrayOfEntityIdentity
     */
    public function setEntityIdentity(array $entityIdentity = array())
    {
        // validation for constraint: array
        if ('' !== ($entityIdentityArrayErrorMessage = self::validateEntityIdentityForArrayConstraintsFromSetEntityIdentity($entityIdentity))) {
            throw new \InvalidArgumentException($entityIdentityArrayErrorMessage, __LINE__);
        }
        if (is_null($entityIdentity) || (is_array($entityIdentity) && empty($entityIdentity))) {
            unset($this->EntityIdentity);
        } else {
            $this->EntityIdentity = $entityIdentity;
        }
        return $this;
    }
    /**
     * Add item to EntityIdentity value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\EntityIdentity $item
     * @return \patest\ArrayType\ArrayOfEntityIdentity
     */
    public function addToEntityIdentity(\patest\StructType\EntityIdentity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\EntityIdentity) {
            throw new \InvalidArgumentException(sprintf('The EntityIdentity property can only contain items of type \patest\StructType\EntityIdentity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EntityIdentity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\EntityIdentity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\EntityIdentity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\EntityIdentity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\EntityIdentity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\EntityIdentity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EntityIdentity
     */
    public function getAttributeName()
    {
        return 'EntityIdentity';
    }
}
