<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBasketItemAccessControlValidationData ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfBasketItemAccessControlValidationData
 * @subpackage Arrays
 */
class ArrayOfBasketItemAccessControlValidationData extends AbstractStructArrayBase
{
    /**
     * The BasketItemAccessControlValidationData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BasketItemAccessControlValidationData[]
     */
    public $BasketItemAccessControlValidationData;
    /**
     * Constructor method for ArrayOfBasketItemAccessControlValidationData
     * @uses ArrayOfBasketItemAccessControlValidationData::setBasketItemAccessControlValidationData()
     * @param \patest\StructType\BasketItemAccessControlValidationData[] $basketItemAccessControlValidationData
     */
    public function __construct(array $basketItemAccessControlValidationData = array())
    {
        $this
            ->setBasketItemAccessControlValidationData($basketItemAccessControlValidationData);
    }
    /**
     * Get BasketItemAccessControlValidationData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BasketItemAccessControlValidationData[]|null
     */
    public function getBasketItemAccessControlValidationData()
    {
        return isset($this->BasketItemAccessControlValidationData) ? $this->BasketItemAccessControlValidationData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBasketItemAccessControlValidationData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBasketItemAccessControlValidationData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBasketItemAccessControlValidationDataForArrayConstraintsFromSetBasketItemAccessControlValidationData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBasketItemAccessControlValidationDataBasketItemAccessControlValidationDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfBasketItemAccessControlValidationDataBasketItemAccessControlValidationDataItem instanceof \patest\StructType\BasketItemAccessControlValidationData) {
                $invalidValues[] = is_object($arrayOfBasketItemAccessControlValidationDataBasketItemAccessControlValidationDataItem) ? get_class($arrayOfBasketItemAccessControlValidationDataBasketItemAccessControlValidationDataItem) : sprintf('%s(%s)', gettype($arrayOfBasketItemAccessControlValidationDataBasketItemAccessControlValidationDataItem), var_export($arrayOfBasketItemAccessControlValidationDataBasketItemAccessControlValidationDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BasketItemAccessControlValidationData property can only contain items of type \patest\StructType\BasketItemAccessControlValidationData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BasketItemAccessControlValidationData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\BasketItemAccessControlValidationData[] $basketItemAccessControlValidationData
     * @return \patest\ArrayType\ArrayOfBasketItemAccessControlValidationData
     */
    public function setBasketItemAccessControlValidationData(array $basketItemAccessControlValidationData = array())
    {
        // validation for constraint: array
        if ('' !== ($basketItemAccessControlValidationDataArrayErrorMessage = self::validateBasketItemAccessControlValidationDataForArrayConstraintsFromSetBasketItemAccessControlValidationData($basketItemAccessControlValidationData))) {
            throw new \InvalidArgumentException($basketItemAccessControlValidationDataArrayErrorMessage, __LINE__);
        }
        if (is_null($basketItemAccessControlValidationData) || (is_array($basketItemAccessControlValidationData) && empty($basketItemAccessControlValidationData))) {
            unset($this->BasketItemAccessControlValidationData);
        } else {
            $this->BasketItemAccessControlValidationData = $basketItemAccessControlValidationData;
        }
        return $this;
    }
    /**
     * Add item to BasketItemAccessControlValidationData value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\BasketItemAccessControlValidationData $item
     * @return \patest\ArrayType\ArrayOfBasketItemAccessControlValidationData
     */
    public function addToBasketItemAccessControlValidationData(\patest\StructType\BasketItemAccessControlValidationData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\BasketItemAccessControlValidationData) {
            throw new \InvalidArgumentException(sprintf('The BasketItemAccessControlValidationData property can only contain items of type \patest\StructType\BasketItemAccessControlValidationData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BasketItemAccessControlValidationData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\BasketItemAccessControlValidationData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\BasketItemAccessControlValidationData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\BasketItemAccessControlValidationData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\BasketItemAccessControlValidationData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\BasketItemAccessControlValidationData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BasketItemAccessControlValidationData
     */
    public function getAttributeName()
    {
        return 'BasketItemAccessControlValidationData';
    }
}
