<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectCariOdemeIadeRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SelectCariOdemeIadeRequest
 * @subpackage Structs
 */
class SelectCariOdemeIadeRequest extends AbstractStructBase
{
    /**
     * The Guid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Guid;
    /**
     * The IslemTip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IslemTip;
    /**
     * The OdemeDurum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OdemeDurum;
    /**
     * The OdemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OdemeId;
    /**
     * Constructor method for SelectCariOdemeIadeRequest
     * @uses SelectCariOdemeIadeRequest::setGuid()
     * @uses SelectCariOdemeIadeRequest::setIslemTip()
     * @uses SelectCariOdemeIadeRequest::setOdemeDurum()
     * @uses SelectCariOdemeIadeRequest::setOdemeId()
     * @param string $guid
     * @param string $islemTip
     * @param string $odemeDurum
     * @param int $odemeId
     */
    public function __construct($guid = null, $islemTip = null, $odemeDurum = null, $odemeId = null)
    {
        $this
            ->setGuid($guid)
            ->setIslemTip($islemTip)
            ->setOdemeDurum($odemeDurum)
            ->setOdemeId($odemeId);
    }
    /**
     * Get Guid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuid()
    {
        return isset($this->Guid) ? $this->Guid : null;
    }
    /**
     * Set Guid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guid
     * @return \StructType\SelectCariOdemeIadeRequest
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guid, true), gettype($guid)), __LINE__);
        }
        if (is_null($guid) || (is_array($guid) && empty($guid))) {
            unset($this->Guid);
        } else {
            $this->Guid = $guid;
        }
        return $this;
    }
    /**
     * Get IslemTip value
     * @return string|null
     */
    public function getIslemTip()
    {
        return $this->IslemTip;
    }
    /**
     * Set IslemTip value
     * @uses \EnumType\OdemeIadeIslemTip::valueIsValid()
     * @uses \EnumType\OdemeIadeIslemTip::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $islemTip
     * @return \StructType\SelectCariOdemeIadeRequest
     */
    public function setIslemTip($islemTip = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OdemeIadeIslemTip::valueIsValid($islemTip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OdemeIadeIslemTip', is_array($islemTip) ? implode(', ', $islemTip) : var_export($islemTip, true), implode(', ', \EnumType\OdemeIadeIslemTip::getValidValues())), __LINE__);
        }
        $this->IslemTip = $islemTip;
        return $this;
    }
    /**
     * Get OdemeDurum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOdemeDurum()
    {
        return isset($this->OdemeDurum) ? $this->OdemeDurum : null;
    }
    /**
     * Set OdemeDurum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\BLEnums_OdemeDurumlari::valueIsValid()
     * @uses \EnumType\BLEnums_OdemeDurumlari::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $odemeDurum
     * @return \StructType\SelectCariOdemeIadeRequest
     */
    public function setOdemeDurum($odemeDurum = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BLEnums_OdemeDurumlari::valueIsValid($odemeDurum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BLEnums_OdemeDurumlari', is_array($odemeDurum) ? implode(', ', $odemeDurum) : var_export($odemeDurum, true), implode(', ', \EnumType\BLEnums_OdemeDurumlari::getValidValues())), __LINE__);
        }
        if (is_null($odemeDurum) || (is_array($odemeDurum) && empty($odemeDurum))) {
            unset($this->OdemeDurum);
        } else {
            $this->OdemeDurum = $odemeDurum;
        }
        return $this;
    }
    /**
     * Get OdemeId value
     * @return int|null
     */
    public function getOdemeId()
    {
        return $this->OdemeId;
    }
    /**
     * Set OdemeId value
     * @param int $odemeId
     * @return \StructType\SelectCariOdemeIadeRequest
     */
    public function setOdemeId($odemeId = null)
    {
        // validation for constraint: int
        if (!is_null($odemeId) && !(is_int($odemeId) || ctype_digit($odemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($odemeId, true), gettype($odemeId)), __LINE__);
        }
        $this->OdemeId = $odemeId;
        return $this;
    }
}
