<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaveCariOdemeIadeRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SaveCariOdemeIadeRequest
 * @subpackage Structs
 */
class SaveCariOdemeIadeRequest extends AbstractStructBase
{
    /**
     * The Guid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Guid;
    /**
     * The OdemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OdemeId;
    /**
     * The Tutar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Tutar;
    /**
     * Constructor method for SaveCariOdemeIadeRequest
     * @uses SaveCariOdemeIadeRequest::setGuid()
     * @uses SaveCariOdemeIadeRequest::setOdemeId()
     * @uses SaveCariOdemeIadeRequest::setTutar()
     * @param string $guid
     * @param int $odemeId
     * @param float $tutar
     */
    public function __construct($guid = null, $odemeId = null, $tutar = null)
    {
        $this
            ->setGuid($guid)
            ->setOdemeId($odemeId)
            ->setTutar($tutar);
    }
    /**
     * Get Guid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuid()
    {
        return isset($this->Guid) ? $this->Guid : null;
    }
    /**
     * Set Guid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guid
     * @return \StructType\SaveCariOdemeIadeRequest
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guid, true), gettype($guid)), __LINE__);
        }
        if (is_null($guid) || (is_array($guid) && empty($guid))) {
            unset($this->Guid);
        } else {
            $this->Guid = $guid;
        }
        return $this;
    }
    /**
     * Get OdemeId value
     * @return int|null
     */
    public function getOdemeId()
    {
        return $this->OdemeId;
    }
    /**
     * Set OdemeId value
     * @param int $odemeId
     * @return \StructType\SaveCariOdemeIadeRequest
     */
    public function setOdemeId($odemeId = null)
    {
        // validation for constraint: int
        if (!is_null($odemeId) && !(is_int($odemeId) || ctype_digit($odemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($odemeId, true), gettype($odemeId)), __LINE__);
        }
        $this->OdemeId = $odemeId;
        return $this;
    }
    /**
     * Get Tutar value
     * @return float|null
     */
    public function getTutar()
    {
        return $this->Tutar;
    }
    /**
     * Set Tutar value
     * @param float $tutar
     * @return \StructType\SaveCariOdemeIadeRequest
     */
    public function setTutar($tutar = null)
    {
        // validation for constraint: float
        if (!is_null($tutar) && !(is_float($tutar) || is_numeric($tutar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tutar, true), gettype($tutar)), __LINE__);
        }
        $this->Tutar = $tutar;
        return $this;
    }
}
