<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormDesignService StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FormDesignService
 * @subpackage Structs
 */
class FormDesignService extends AbstractStructBase
{
    /**
     * The FormDesignNotDiscountedTotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FormDesignNotDiscountedTotalPrice;
    /**
     * The FormDesignTotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FormDesignTotalPrice;
    /**
     * The FormDesignUnitNotDiscountedPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FormDesignUnitNotDiscountedPrice;
    /**
     * The FormDesignUnitPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FormDesignUnitPrice;
    /**
     * The NameToBePrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameToBePrinted;
    /**
     * The NameToBePrintedTotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $NameToBePrintedTotalPrice;
    /**
     * The NameToBePrintedUnitPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $NameToBePrintedUnitPrice;
    /**
     * The NumberToBePrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumberToBePrinted;
    /**
     * The NumberToBePrintedTotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $NumberToBePrintedTotalPrice;
    /**
     * The NumberToBePrintedUnitPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $NumberToBePrintedUnitPrice;
    /**
     * The SelectedPlayer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SelectedPlayerService
     */
    public $SelectedPlayer;
    /**
     * The SelectedSignatures
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSelectedSignature
     */
    public $SelectedSignatures;
    /**
     * The SignatureTotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SignatureTotalPrice;
    /**
     * The SignatureUnitPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SignatureUnitPrice;
    /**
     * Constructor method for FormDesignService
     * @uses FormDesignService::setFormDesignNotDiscountedTotalPrice()
     * @uses FormDesignService::setFormDesignTotalPrice()
     * @uses FormDesignService::setFormDesignUnitNotDiscountedPrice()
     * @uses FormDesignService::setFormDesignUnitPrice()
     * @uses FormDesignService::setNameToBePrinted()
     * @uses FormDesignService::setNameToBePrintedTotalPrice()
     * @uses FormDesignService::setNameToBePrintedUnitPrice()
     * @uses FormDesignService::setNumberToBePrinted()
     * @uses FormDesignService::setNumberToBePrintedTotalPrice()
     * @uses FormDesignService::setNumberToBePrintedUnitPrice()
     * @uses FormDesignService::setSelectedPlayer()
     * @uses FormDesignService::setSelectedSignatures()
     * @uses FormDesignService::setSignatureTotalPrice()
     * @uses FormDesignService::setSignatureUnitPrice()
     * @param float $formDesignNotDiscountedTotalPrice
     * @param float $formDesignTotalPrice
     * @param float $formDesignUnitNotDiscountedPrice
     * @param float $formDesignUnitPrice
     * @param string $nameToBePrinted
     * @param float $nameToBePrintedTotalPrice
     * @param float $nameToBePrintedUnitPrice
     * @param string $numberToBePrinted
     * @param float $numberToBePrintedTotalPrice
     * @param float $numberToBePrintedUnitPrice
     * @param \StructType\SelectedPlayerService $selectedPlayer
     * @param \ArrayType\ArrayOfSelectedSignature $selectedSignatures
     * @param float $signatureTotalPrice
     * @param float $signatureUnitPrice
     */
    public function __construct($formDesignNotDiscountedTotalPrice = null, $formDesignTotalPrice = null, $formDesignUnitNotDiscountedPrice = null, $formDesignUnitPrice = null, $nameToBePrinted = null, $nameToBePrintedTotalPrice = null, $nameToBePrintedUnitPrice = null, $numberToBePrinted = null, $numberToBePrintedTotalPrice = null, $numberToBePrintedUnitPrice = null, \StructType\SelectedPlayerService $selectedPlayer = null, \ArrayType\ArrayOfSelectedSignature $selectedSignatures = null, $signatureTotalPrice = null, $signatureUnitPrice = null)
    {
        $this
            ->setFormDesignNotDiscountedTotalPrice($formDesignNotDiscountedTotalPrice)
            ->setFormDesignTotalPrice($formDesignTotalPrice)
            ->setFormDesignUnitNotDiscountedPrice($formDesignUnitNotDiscountedPrice)
            ->setFormDesignUnitPrice($formDesignUnitPrice)
            ->setNameToBePrinted($nameToBePrinted)
            ->setNameToBePrintedTotalPrice($nameToBePrintedTotalPrice)
            ->setNameToBePrintedUnitPrice($nameToBePrintedUnitPrice)
            ->setNumberToBePrinted($numberToBePrinted)
            ->setNumberToBePrintedTotalPrice($numberToBePrintedTotalPrice)
            ->setNumberToBePrintedUnitPrice($numberToBePrintedUnitPrice)
            ->setSelectedPlayer($selectedPlayer)
            ->setSelectedSignatures($selectedSignatures)
            ->setSignatureTotalPrice($signatureTotalPrice)
            ->setSignatureUnitPrice($signatureUnitPrice);
    }
    /**
     * Get FormDesignNotDiscountedTotalPrice value
     * @return float|null
     */
    public function getFormDesignNotDiscountedTotalPrice()
    {
        return $this->FormDesignNotDiscountedTotalPrice;
    }
    /**
     * Set FormDesignNotDiscountedTotalPrice value
     * @param float $formDesignNotDiscountedTotalPrice
     * @return \StructType\FormDesignService
     */
    public function setFormDesignNotDiscountedTotalPrice($formDesignNotDiscountedTotalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($formDesignNotDiscountedTotalPrice) && !(is_float($formDesignNotDiscountedTotalPrice) || is_numeric($formDesignNotDiscountedTotalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($formDesignNotDiscountedTotalPrice, true), gettype($formDesignNotDiscountedTotalPrice)), __LINE__);
        }
        $this->FormDesignNotDiscountedTotalPrice = $formDesignNotDiscountedTotalPrice;
        return $this;
    }
    /**
     * Get FormDesignTotalPrice value
     * @return float|null
     */
    public function getFormDesignTotalPrice()
    {
        return $this->FormDesignTotalPrice;
    }
    /**
     * Set FormDesignTotalPrice value
     * @param float $formDesignTotalPrice
     * @return \StructType\FormDesignService
     */
    public function setFormDesignTotalPrice($formDesignTotalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($formDesignTotalPrice) && !(is_float($formDesignTotalPrice) || is_numeric($formDesignTotalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($formDesignTotalPrice, true), gettype($formDesignTotalPrice)), __LINE__);
        }
        $this->FormDesignTotalPrice = $formDesignTotalPrice;
        return $this;
    }
    /**
     * Get FormDesignUnitNotDiscountedPrice value
     * @return float|null
     */
    public function getFormDesignUnitNotDiscountedPrice()
    {
        return $this->FormDesignUnitNotDiscountedPrice;
    }
    /**
     * Set FormDesignUnitNotDiscountedPrice value
     * @param float $formDesignUnitNotDiscountedPrice
     * @return \StructType\FormDesignService
     */
    public function setFormDesignUnitNotDiscountedPrice($formDesignUnitNotDiscountedPrice = null)
    {
        // validation for constraint: float
        if (!is_null($formDesignUnitNotDiscountedPrice) && !(is_float($formDesignUnitNotDiscountedPrice) || is_numeric($formDesignUnitNotDiscountedPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($formDesignUnitNotDiscountedPrice, true), gettype($formDesignUnitNotDiscountedPrice)), __LINE__);
        }
        $this->FormDesignUnitNotDiscountedPrice = $formDesignUnitNotDiscountedPrice;
        return $this;
    }
    /**
     * Get FormDesignUnitPrice value
     * @return float|null
     */
    public function getFormDesignUnitPrice()
    {
        return $this->FormDesignUnitPrice;
    }
    /**
     * Set FormDesignUnitPrice value
     * @param float $formDesignUnitPrice
     * @return \StructType\FormDesignService
     */
    public function setFormDesignUnitPrice($formDesignUnitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($formDesignUnitPrice) && !(is_float($formDesignUnitPrice) || is_numeric($formDesignUnitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($formDesignUnitPrice, true), gettype($formDesignUnitPrice)), __LINE__);
        }
        $this->FormDesignUnitPrice = $formDesignUnitPrice;
        return $this;
    }
    /**
     * Get NameToBePrinted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameToBePrinted()
    {
        return isset($this->NameToBePrinted) ? $this->NameToBePrinted : null;
    }
    /**
     * Set NameToBePrinted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameToBePrinted
     * @return \StructType\FormDesignService
     */
    public function setNameToBePrinted($nameToBePrinted = null)
    {
        // validation for constraint: string
        if (!is_null($nameToBePrinted) && !is_string($nameToBePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameToBePrinted, true), gettype($nameToBePrinted)), __LINE__);
        }
        if (is_null($nameToBePrinted) || (is_array($nameToBePrinted) && empty($nameToBePrinted))) {
            unset($this->NameToBePrinted);
        } else {
            $this->NameToBePrinted = $nameToBePrinted;
        }
        return $this;
    }
    /**
     * Get NameToBePrintedTotalPrice value
     * @return float|null
     */
    public function getNameToBePrintedTotalPrice()
    {
        return $this->NameToBePrintedTotalPrice;
    }
    /**
     * Set NameToBePrintedTotalPrice value
     * @param float $nameToBePrintedTotalPrice
     * @return \StructType\FormDesignService
     */
    public function setNameToBePrintedTotalPrice($nameToBePrintedTotalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($nameToBePrintedTotalPrice) && !(is_float($nameToBePrintedTotalPrice) || is_numeric($nameToBePrintedTotalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nameToBePrintedTotalPrice, true), gettype($nameToBePrintedTotalPrice)), __LINE__);
        }
        $this->NameToBePrintedTotalPrice = $nameToBePrintedTotalPrice;
        return $this;
    }
    /**
     * Get NameToBePrintedUnitPrice value
     * @return float|null
     */
    public function getNameToBePrintedUnitPrice()
    {
        return $this->NameToBePrintedUnitPrice;
    }
    /**
     * Set NameToBePrintedUnitPrice value
     * @param float $nameToBePrintedUnitPrice
     * @return \StructType\FormDesignService
     */
    public function setNameToBePrintedUnitPrice($nameToBePrintedUnitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($nameToBePrintedUnitPrice) && !(is_float($nameToBePrintedUnitPrice) || is_numeric($nameToBePrintedUnitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nameToBePrintedUnitPrice, true), gettype($nameToBePrintedUnitPrice)), __LINE__);
        }
        $this->NameToBePrintedUnitPrice = $nameToBePrintedUnitPrice;
        return $this;
    }
    /**
     * Get NumberToBePrinted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberToBePrinted()
    {
        return isset($this->NumberToBePrinted) ? $this->NumberToBePrinted : null;
    }
    /**
     * Set NumberToBePrinted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberToBePrinted
     * @return \StructType\FormDesignService
     */
    public function setNumberToBePrinted($numberToBePrinted = null)
    {
        // validation for constraint: string
        if (!is_null($numberToBePrinted) && !is_string($numberToBePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberToBePrinted, true), gettype($numberToBePrinted)), __LINE__);
        }
        if (is_null($numberToBePrinted) || (is_array($numberToBePrinted) && empty($numberToBePrinted))) {
            unset($this->NumberToBePrinted);
        } else {
            $this->NumberToBePrinted = $numberToBePrinted;
        }
        return $this;
    }
    /**
     * Get NumberToBePrintedTotalPrice value
     * @return float|null
     */
    public function getNumberToBePrintedTotalPrice()
    {
        return $this->NumberToBePrintedTotalPrice;
    }
    /**
     * Set NumberToBePrintedTotalPrice value
     * @param float $numberToBePrintedTotalPrice
     * @return \StructType\FormDesignService
     */
    public function setNumberToBePrintedTotalPrice($numberToBePrintedTotalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($numberToBePrintedTotalPrice) && !(is_float($numberToBePrintedTotalPrice) || is_numeric($numberToBePrintedTotalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($numberToBePrintedTotalPrice, true), gettype($numberToBePrintedTotalPrice)), __LINE__);
        }
        $this->NumberToBePrintedTotalPrice = $numberToBePrintedTotalPrice;
        return $this;
    }
    /**
     * Get NumberToBePrintedUnitPrice value
     * @return float|null
     */
    public function getNumberToBePrintedUnitPrice()
    {
        return $this->NumberToBePrintedUnitPrice;
    }
    /**
     * Set NumberToBePrintedUnitPrice value
     * @param float $numberToBePrintedUnitPrice
     * @return \StructType\FormDesignService
     */
    public function setNumberToBePrintedUnitPrice($numberToBePrintedUnitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($numberToBePrintedUnitPrice) && !(is_float($numberToBePrintedUnitPrice) || is_numeric($numberToBePrintedUnitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($numberToBePrintedUnitPrice, true), gettype($numberToBePrintedUnitPrice)), __LINE__);
        }
        $this->NumberToBePrintedUnitPrice = $numberToBePrintedUnitPrice;
        return $this;
    }
    /**
     * Get SelectedPlayer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SelectedPlayerService|null
     */
    public function getSelectedPlayer()
    {
        return isset($this->SelectedPlayer) ? $this->SelectedPlayer : null;
    }
    /**
     * Set SelectedPlayer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SelectedPlayerService $selectedPlayer
     * @return \StructType\FormDesignService
     */
    public function setSelectedPlayer(\StructType\SelectedPlayerService $selectedPlayer = null)
    {
        if (is_null($selectedPlayer) || (is_array($selectedPlayer) && empty($selectedPlayer))) {
            unset($this->SelectedPlayer);
        } else {
            $this->SelectedPlayer = $selectedPlayer;
        }
        return $this;
    }
    /**
     * Get SelectedSignatures value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSelectedSignature|null
     */
    public function getSelectedSignatures()
    {
        return isset($this->SelectedSignatures) ? $this->SelectedSignatures : null;
    }
    /**
     * Set SelectedSignatures value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSelectedSignature $selectedSignatures
     * @return \StructType\FormDesignService
     */
    public function setSelectedSignatures(\ArrayType\ArrayOfSelectedSignature $selectedSignatures = null)
    {
        if (is_null($selectedSignatures) || (is_array($selectedSignatures) && empty($selectedSignatures))) {
            unset($this->SelectedSignatures);
        } else {
            $this->SelectedSignatures = $selectedSignatures;
        }
        return $this;
    }
    /**
     * Get SignatureTotalPrice value
     * @return float|null
     */
    public function getSignatureTotalPrice()
    {
        return $this->SignatureTotalPrice;
    }
    /**
     * Set SignatureTotalPrice value
     * @param float $signatureTotalPrice
     * @return \StructType\FormDesignService
     */
    public function setSignatureTotalPrice($signatureTotalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($signatureTotalPrice) && !(is_float($signatureTotalPrice) || is_numeric($signatureTotalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($signatureTotalPrice, true), gettype($signatureTotalPrice)), __LINE__);
        }
        $this->SignatureTotalPrice = $signatureTotalPrice;
        return $this;
    }
    /**
     * Get SignatureUnitPrice value
     * @return float|null
     */
    public function getSignatureUnitPrice()
    {
        return $this->SignatureUnitPrice;
    }
    /**
     * Set SignatureUnitPrice value
     * @param float $signatureUnitPrice
     * @return \StructType\FormDesignService
     */
    public function setSignatureUnitPrice($signatureUnitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($signatureUnitPrice) && !(is_float($signatureUnitPrice) || is_numeric($signatureUnitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($signatureUnitPrice, true), gettype($signatureUnitPrice)), __LINE__);
        }
        $this->SignatureUnitPrice = $signatureUnitPrice;
        return $this;
    }
}
