<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebMenu StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebMenu
 * @subpackage Structs
 */
class WebMenu extends AbstractStructBase
{
    /**
     * The Aktif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktif;
    /**
     * The Baslik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Baslik;
    /**
     * The BitisTarihi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BitisTarihi;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Icerik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Icerik;
    /**
     * The PID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PID;
    /**
     * The Resim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Resim;
    /**
     * The ResimTargetUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResimTargetUrl;
    /**
     * The ResimYolu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResimYolu;
    /**
     * The Sira
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Sira;
    /**
     * The Target
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Target;
    /**
     * The Tip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tip;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Url;
    /**
     * Constructor method for WebMenu
     * @uses WebMenu::setAktif()
     * @uses WebMenu::setBaslik()
     * @uses WebMenu::setBitisTarihi()
     * @uses WebMenu::setID()
     * @uses WebMenu::setIcerik()
     * @uses WebMenu::setPID()
     * @uses WebMenu::setResim()
     * @uses WebMenu::setResimTargetUrl()
     * @uses WebMenu::setResimYolu()
     * @uses WebMenu::setSira()
     * @uses WebMenu::setTarget()
     * @uses WebMenu::setTip()
     * @uses WebMenu::setUrl()
     * @param bool $aktif
     * @param string $baslik
     * @param string $bitisTarihi
     * @param int $iD
     * @param string $icerik
     * @param int $pID
     * @param string $resim
     * @param string $resimTargetUrl
     * @param string $resimYolu
     * @param int $sira
     * @param string $target
     * @param int $tip
     * @param string $url
     */
    public function __construct($aktif = null, $baslik = null, $bitisTarihi = null, $iD = null, $icerik = null, $pID = null, $resim = null, $resimTargetUrl = null, $resimYolu = null, $sira = null, $target = null, $tip = null, $url = null)
    {
        $this
            ->setAktif($aktif)
            ->setBaslik($baslik)
            ->setBitisTarihi($bitisTarihi)
            ->setID($iD)
            ->setIcerik($icerik)
            ->setPID($pID)
            ->setResim($resim)
            ->setResimTargetUrl($resimTargetUrl)
            ->setResimYolu($resimYolu)
            ->setSira($sira)
            ->setTarget($target)
            ->setTip($tip)
            ->setUrl($url);
    }
    /**
     * Get Aktif value
     * @return bool|null
     */
    public function getAktif()
    {
        return $this->Aktif;
    }
    /**
     * Set Aktif value
     * @param bool $aktif
     * @return \StructType\WebMenu
     */
    public function setAktif($aktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktif) && !is_bool($aktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktif, true), gettype($aktif)), __LINE__);
        }
        $this->Aktif = $aktif;
        return $this;
    }
    /**
     * Get Baslik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBaslik()
    {
        return isset($this->Baslik) ? $this->Baslik : null;
    }
    /**
     * Set Baslik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $baslik
     * @return \StructType\WebMenu
     */
    public function setBaslik($baslik = null)
    {
        // validation for constraint: string
        if (!is_null($baslik) && !is_string($baslik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baslik, true), gettype($baslik)), __LINE__);
        }
        if (is_null($baslik) || (is_array($baslik) && empty($baslik))) {
            unset($this->Baslik);
        } else {
            $this->Baslik = $baslik;
        }
        return $this;
    }
    /**
     * Get BitisTarihi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBitisTarihi()
    {
        return isset($this->BitisTarihi) ? $this->BitisTarihi : null;
    }
    /**
     * Set BitisTarihi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bitisTarihi
     * @return \StructType\WebMenu
     */
    public function setBitisTarihi($bitisTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($bitisTarihi) && !is_string($bitisTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bitisTarihi, true), gettype($bitisTarihi)), __LINE__);
        }
        if (is_null($bitisTarihi) || (is_array($bitisTarihi) && empty($bitisTarihi))) {
            unset($this->BitisTarihi);
        } else {
            $this->BitisTarihi = $bitisTarihi;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\WebMenu
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Icerik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIcerik()
    {
        return isset($this->Icerik) ? $this->Icerik : null;
    }
    /**
     * Set Icerik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $icerik
     * @return \StructType\WebMenu
     */
    public function setIcerik($icerik = null)
    {
        // validation for constraint: string
        if (!is_null($icerik) && !is_string($icerik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($icerik, true), gettype($icerik)), __LINE__);
        }
        if (is_null($icerik) || (is_array($icerik) && empty($icerik))) {
            unset($this->Icerik);
        } else {
            $this->Icerik = $icerik;
        }
        return $this;
    }
    /**
     * Get PID value
     * @return int|null
     */
    public function getPID()
    {
        return $this->PID;
    }
    /**
     * Set PID value
     * @param int $pID
     * @return \StructType\WebMenu
     */
    public function setPID($pID = null)
    {
        // validation for constraint: int
        if (!is_null($pID) && !(is_int($pID) || ctype_digit($pID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pID, true), gettype($pID)), __LINE__);
        }
        $this->PID = $pID;
        return $this;
    }
    /**
     * Get Resim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResim()
    {
        return isset($this->Resim) ? $this->Resim : null;
    }
    /**
     * Set Resim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resim
     * @return \StructType\WebMenu
     */
    public function setResim($resim = null)
    {
        // validation for constraint: string
        if (!is_null($resim) && !is_string($resim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resim, true), gettype($resim)), __LINE__);
        }
        if (is_null($resim) || (is_array($resim) && empty($resim))) {
            unset($this->Resim);
        } else {
            $this->Resim = $resim;
        }
        return $this;
    }
    /**
     * Get ResimTargetUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResimTargetUrl()
    {
        return isset($this->ResimTargetUrl) ? $this->ResimTargetUrl : null;
    }
    /**
     * Set ResimTargetUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resimTargetUrl
     * @return \StructType\WebMenu
     */
    public function setResimTargetUrl($resimTargetUrl = null)
    {
        // validation for constraint: string
        if (!is_null($resimTargetUrl) && !is_string($resimTargetUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resimTargetUrl, true), gettype($resimTargetUrl)), __LINE__);
        }
        if (is_null($resimTargetUrl) || (is_array($resimTargetUrl) && empty($resimTargetUrl))) {
            unset($this->ResimTargetUrl);
        } else {
            $this->ResimTargetUrl = $resimTargetUrl;
        }
        return $this;
    }
    /**
     * Get ResimYolu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResimYolu()
    {
        return isset($this->ResimYolu) ? $this->ResimYolu : null;
    }
    /**
     * Set ResimYolu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resimYolu
     * @return \StructType\WebMenu
     */
    public function setResimYolu($resimYolu = null)
    {
        // validation for constraint: string
        if (!is_null($resimYolu) && !is_string($resimYolu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resimYolu, true), gettype($resimYolu)), __LINE__);
        }
        if (is_null($resimYolu) || (is_array($resimYolu) && empty($resimYolu))) {
            unset($this->ResimYolu);
        } else {
            $this->ResimYolu = $resimYolu;
        }
        return $this;
    }
    /**
     * Get Sira value
     * @return int|null
     */
    public function getSira()
    {
        return $this->Sira;
    }
    /**
     * Set Sira value
     * @param int $sira
     * @return \StructType\WebMenu
     */
    public function setSira($sira = null)
    {
        // validation for constraint: int
        if (!is_null($sira) && !(is_int($sira) || ctype_digit($sira))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sira, true), gettype($sira)), __LINE__);
        }
        $this->Sira = $sira;
        return $this;
    }
    /**
     * Get Target value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTarget()
    {
        return isset($this->Target) ? $this->Target : null;
    }
    /**
     * Set Target value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $target
     * @return \StructType\WebMenu
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        if (is_null($target) || (is_array($target) && empty($target))) {
            unset($this->Target);
        } else {
            $this->Target = $target;
        }
        return $this;
    }
    /**
     * Get Tip value
     * @return int|null
     */
    public function getTip()
    {
        return $this->Tip;
    }
    /**
     * Set Tip value
     * @param int $tip
     * @return \StructType\WebMenu
     */
    public function setTip($tip = null)
    {
        // validation for constraint: int
        if (!is_null($tip) && !(is_int($tip) || ctype_digit($tip))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tip, true), gettype($tip)), __LINE__);
        }
        $this->Tip = $tip;
        return $this;
    }
    /**
     * Get Url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl()
    {
        return isset($this->Url) ? $this->Url : null;
    }
    /**
     * Set Url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url
     * @return \StructType\WebMenu
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        if (is_null($url) || (is_array($url) && empty($url))) {
            unset($this->Url);
        } else {
            $this->Url = $url;
        }
        return $this;
    }
}
