<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebKampanyaHediyeCeki StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebKampanyaHediyeCeki
 * @subpackage Structs
 */
class WebKampanyaHediyeCeki extends AbstractStructBase
{
    /**
     * The BaskaKampanyalarlaBilestirilebilir
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $BaskaKampanyalarlaBilestirilebilir;
    /**
     * The BaslamaSuresi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BaslamaSuresi;
    /**
     * The BaslangicTarihi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BaslangicTarihi;
    /**
     * The BirlestirilebilirKampanyalar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebKampanyaIDTanim
     */
    public $BirlestirilebilirKampanyalar;
    /**
     * The BitisTarihi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BitisTarihi;
    /**
     * The GecerliOlduguSure
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GecerliOlduguSure;
    /**
     * The IndirimliUrunleKullanilabilir
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IndirimliUrunleKullanilabilir;
    /**
     * The IslemDegeri
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $IslemDegeri;
    /**
     * The IslemTipi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IslemTipi;
    /**
     * The KargoIndirimi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $KargoIndirimi;
    /**
     * The KargoUcretsiz
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $KargoUcretsiz;
    /**
     * The Kategoriler
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebKampanyaIDTanim
     */
    public $Kategoriler;
    /**
     * The KullanimSayisi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KullanimSayisi;
    /**
     * The Markalar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebKampanyaIDTanim
     */
    public $Markalar;
    /**
     * The MinimumSepetTutari
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MinimumSepetTutari;
    /**
     * The SiparisTarihineGoreOlustur
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SiparisTarihineGoreOlustur;
    /**
     * The UyeMaksKullanimSayisi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UyeMaksKullanimSayisi;
    /**
     * Constructor method for WebKampanyaHediyeCeki
     * @uses WebKampanyaHediyeCeki::setBaskaKampanyalarlaBilestirilebilir()
     * @uses WebKampanyaHediyeCeki::setBaslamaSuresi()
     * @uses WebKampanyaHediyeCeki::setBaslangicTarihi()
     * @uses WebKampanyaHediyeCeki::setBirlestirilebilirKampanyalar()
     * @uses WebKampanyaHediyeCeki::setBitisTarihi()
     * @uses WebKampanyaHediyeCeki::setGecerliOlduguSure()
     * @uses WebKampanyaHediyeCeki::setIndirimliUrunleKullanilabilir()
     * @uses WebKampanyaHediyeCeki::setIslemDegeri()
     * @uses WebKampanyaHediyeCeki::setIslemTipi()
     * @uses WebKampanyaHediyeCeki::setKargoIndirimi()
     * @uses WebKampanyaHediyeCeki::setKargoUcretsiz()
     * @uses WebKampanyaHediyeCeki::setKategoriler()
     * @uses WebKampanyaHediyeCeki::setKullanimSayisi()
     * @uses WebKampanyaHediyeCeki::setMarkalar()
     * @uses WebKampanyaHediyeCeki::setMinimumSepetTutari()
     * @uses WebKampanyaHediyeCeki::setSiparisTarihineGoreOlustur()
     * @uses WebKampanyaHediyeCeki::setUyeMaksKullanimSayisi()
     * @param bool $baskaKampanyalarlaBilestirilebilir
     * @param int $baslamaSuresi
     * @param string $baslangicTarihi
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $birlestirilebilirKampanyalar
     * @param string $bitisTarihi
     * @param int $gecerliOlduguSure
     * @param bool $indirimliUrunleKullanilabilir
     * @param float $islemDegeri
     * @param int $islemTipi
     * @param bool $kargoIndirimi
     * @param bool $kargoUcretsiz
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $kategoriler
     * @param int $kullanimSayisi
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $markalar
     * @param float $minimumSepetTutari
     * @param bool $siparisTarihineGoreOlustur
     * @param int $uyeMaksKullanimSayisi
     */
    public function __construct($baskaKampanyalarlaBilestirilebilir = null, $baslamaSuresi = null, $baslangicTarihi = null, \ArrayType\ArrayOfWebKampanyaIDTanim $birlestirilebilirKampanyalar = null, $bitisTarihi = null, $gecerliOlduguSure = null, $indirimliUrunleKullanilabilir = null, $islemDegeri = null, $islemTipi = null, $kargoIndirimi = null, $kargoUcretsiz = null, \ArrayType\ArrayOfWebKampanyaIDTanim $kategoriler = null, $kullanimSayisi = null, \ArrayType\ArrayOfWebKampanyaIDTanim $markalar = null, $minimumSepetTutari = null, $siparisTarihineGoreOlustur = null, $uyeMaksKullanimSayisi = null)
    {
        $this
            ->setBaskaKampanyalarlaBilestirilebilir($baskaKampanyalarlaBilestirilebilir)
            ->setBaslamaSuresi($baslamaSuresi)
            ->setBaslangicTarihi($baslangicTarihi)
            ->setBirlestirilebilirKampanyalar($birlestirilebilirKampanyalar)
            ->setBitisTarihi($bitisTarihi)
            ->setGecerliOlduguSure($gecerliOlduguSure)
            ->setIndirimliUrunleKullanilabilir($indirimliUrunleKullanilabilir)
            ->setIslemDegeri($islemDegeri)
            ->setIslemTipi($islemTipi)
            ->setKargoIndirimi($kargoIndirimi)
            ->setKargoUcretsiz($kargoUcretsiz)
            ->setKategoriler($kategoriler)
            ->setKullanimSayisi($kullanimSayisi)
            ->setMarkalar($markalar)
            ->setMinimumSepetTutari($minimumSepetTutari)
            ->setSiparisTarihineGoreOlustur($siparisTarihineGoreOlustur)
            ->setUyeMaksKullanimSayisi($uyeMaksKullanimSayisi);
    }
    /**
     * Get BaskaKampanyalarlaBilestirilebilir value
     * @return bool|null
     */
    public function getBaskaKampanyalarlaBilestirilebilir()
    {
        return $this->BaskaKampanyalarlaBilestirilebilir;
    }
    /**
     * Set BaskaKampanyalarlaBilestirilebilir value
     * @param bool $baskaKampanyalarlaBilestirilebilir
     * @return \StructType\WebKampanyaHediyeCeki
     */
    public function setBaskaKampanyalarlaBilestirilebilir($baskaKampanyalarlaBilestirilebilir = null)
    {
        // validation for constraint: boolean
        if (!is_null($baskaKampanyalarlaBilestirilebilir) && !is_bool($baskaKampanyalarlaBilestirilebilir)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($baskaKampanyalarlaBilestirilebilir, true), gettype($baskaKampanyalarlaBilestirilebilir)), __LINE__);
        }
        $this->BaskaKampanyalarlaBilestirilebilir = $baskaKampanyalarlaBilestirilebilir;
        return $this;
    }
    /**
     * Get BaslamaSuresi value
     * @return int|null
     */
    public function getBaslamaSuresi()
    {
        return $this->BaslamaSuresi;
    }
    /**
     * Set BaslamaSuresi value
     * @param int $baslamaSuresi
     * @return \StructType\WebKampanyaHediyeCeki
     */
    public function setBaslamaSuresi($baslamaSuresi = null)
    {
        // validation for constraint: int
        if (!is_null($baslamaSuresi) && !(is_int($baslamaSuresi) || ctype_digit($baslamaSuresi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($baslamaSuresi, true), gettype($baslamaSuresi)), __LINE__);
        }
        $this->BaslamaSuresi = $baslamaSuresi;
        return $this;
    }
    /**
     * Get BaslangicTarihi value
     * @return string|null
     */
    public function getBaslangicTarihi()
    {
        return $this->BaslangicTarihi;
    }
    /**
     * Set BaslangicTarihi value
     * @param string $baslangicTarihi
     * @return \StructType\WebKampanyaHediyeCeki
     */
    public function setBaslangicTarihi($baslangicTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($baslangicTarihi) && !is_string($baslangicTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baslangicTarihi, true), gettype($baslangicTarihi)), __LINE__);
        }
        $this->BaslangicTarihi = $baslangicTarihi;
        return $this;
    }
    /**
     * Get BirlestirilebilirKampanyalar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebKampanyaIDTanim|null
     */
    public function getBirlestirilebilirKampanyalar()
    {
        return isset($this->BirlestirilebilirKampanyalar) ? $this->BirlestirilebilirKampanyalar : null;
    }
    /**
     * Set BirlestirilebilirKampanyalar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $birlestirilebilirKampanyalar
     * @return \StructType\WebKampanyaHediyeCeki
     */
    public function setBirlestirilebilirKampanyalar(\ArrayType\ArrayOfWebKampanyaIDTanim $birlestirilebilirKampanyalar = null)
    {
        if (is_null($birlestirilebilirKampanyalar) || (is_array($birlestirilebilirKampanyalar) && empty($birlestirilebilirKampanyalar))) {
            unset($this->BirlestirilebilirKampanyalar);
        } else {
            $this->BirlestirilebilirKampanyalar = $birlestirilebilirKampanyalar;
        }
        return $this;
    }
    /**
     * Get BitisTarihi value
     * @return string|null
     */
    public function getBitisTarihi()
    {
        return $this->BitisTarihi;
    }
    /**
     * Set BitisTarihi value
     * @param string $bitisTarihi
     * @return \StructType\WebKampanyaHediyeCeki
     */
    public function setBitisTarihi($bitisTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($bitisTarihi) && !is_string($bitisTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bitisTarihi, true), gettype($bitisTarihi)), __LINE__);
        }
        $this->BitisTarihi = $bitisTarihi;
        return $this;
    }
    /**
     * Get GecerliOlduguSure value
     * @return int|null
     */
    public function getGecerliOlduguSure()
    {
        return $this->GecerliOlduguSure;
    }
    /**
     * Set GecerliOlduguSure value
     * @param int $gecerliOlduguSure
     * @return \StructType\WebKampanyaHediyeCeki
     */
    public function setGecerliOlduguSure($gecerliOlduguSure = null)
    {
        // validation for constraint: int
        if (!is_null($gecerliOlduguSure) && !(is_int($gecerliOlduguSure) || ctype_digit($gecerliOlduguSure))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gecerliOlduguSure, true), gettype($gecerliOlduguSure)), __LINE__);
        }
        $this->GecerliOlduguSure = $gecerliOlduguSure;
        return $this;
    }
    /**
     * Get IndirimliUrunleKullanilabilir value
     * @return bool|null
     */
    public function getIndirimliUrunleKullanilabilir()
    {
        return $this->IndirimliUrunleKullanilabilir;
    }
    /**
     * Set IndirimliUrunleKullanilabilir value
     * @param bool $indirimliUrunleKullanilabilir
     * @return \StructType\WebKampanyaHediyeCeki
     */
    public function setIndirimliUrunleKullanilabilir($indirimliUrunleKullanilabilir = null)
    {
        // validation for constraint: boolean
        if (!is_null($indirimliUrunleKullanilabilir) && !is_bool($indirimliUrunleKullanilabilir)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($indirimliUrunleKullanilabilir, true), gettype($indirimliUrunleKullanilabilir)), __LINE__);
        }
        $this->IndirimliUrunleKullanilabilir = $indirimliUrunleKullanilabilir;
        return $this;
    }
    /**
     * Get IslemDegeri value
     * @return float|null
     */
    public function getIslemDegeri()
    {
        return $this->IslemDegeri;
    }
    /**
     * Set IslemDegeri value
     * @param float $islemDegeri
     * @return \StructType\WebKampanyaHediyeCeki
     */
    public function setIslemDegeri($islemDegeri = null)
    {
        // validation for constraint: float
        if (!is_null($islemDegeri) && !(is_float($islemDegeri) || is_numeric($islemDegeri))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($islemDegeri, true), gettype($islemDegeri)), __LINE__);
        }
        $this->IslemDegeri = $islemDegeri;
        return $this;
    }
    /**
     * Get IslemTipi value
     * @return int|null
     */
    public function getIslemTipi()
    {
        return $this->IslemTipi;
    }
    /**
     * Set IslemTipi value
     * @param int $islemTipi
     * @return \StructType\WebKampanyaHediyeCeki
     */
    public function setIslemTipi($islemTipi = null)
    {
        // validation for constraint: int
        if (!is_null($islemTipi) && !(is_int($islemTipi) || ctype_digit($islemTipi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($islemTipi, true), gettype($islemTipi)), __LINE__);
        }
        $this->IslemTipi = $islemTipi;
        return $this;
    }
    /**
     * Get KargoIndirimi value
     * @return bool|null
     */
    public function getKargoIndirimi()
    {
        return $this->KargoIndirimi;
    }
    /**
     * Set KargoIndirimi value
     * @param bool $kargoIndirimi
     * @return \StructType\WebKampanyaHediyeCeki
     */
    public function setKargoIndirimi($kargoIndirimi = null)
    {
        // validation for constraint: boolean
        if (!is_null($kargoIndirimi) && !is_bool($kargoIndirimi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kargoIndirimi, true), gettype($kargoIndirimi)), __LINE__);
        }
        $this->KargoIndirimi = $kargoIndirimi;
        return $this;
    }
    /**
     * Get KargoUcretsiz value
     * @return bool|null
     */
    public function getKargoUcretsiz()
    {
        return $this->KargoUcretsiz;
    }
    /**
     * Set KargoUcretsiz value
     * @param bool $kargoUcretsiz
     * @return \StructType\WebKampanyaHediyeCeki
     */
    public function setKargoUcretsiz($kargoUcretsiz = null)
    {
        // validation for constraint: boolean
        if (!is_null($kargoUcretsiz) && !is_bool($kargoUcretsiz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kargoUcretsiz, true), gettype($kargoUcretsiz)), __LINE__);
        }
        $this->KargoUcretsiz = $kargoUcretsiz;
        return $this;
    }
    /**
     * Get Kategoriler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebKampanyaIDTanim|null
     */
    public function getKategoriler()
    {
        return isset($this->Kategoriler) ? $this->Kategoriler : null;
    }
    /**
     * Set Kategoriler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $kategoriler
     * @return \StructType\WebKampanyaHediyeCeki
     */
    public function setKategoriler(\ArrayType\ArrayOfWebKampanyaIDTanim $kategoriler = null)
    {
        if (is_null($kategoriler) || (is_array($kategoriler) && empty($kategoriler))) {
            unset($this->Kategoriler);
        } else {
            $this->Kategoriler = $kategoriler;
        }
        return $this;
    }
    /**
     * Get KullanimSayisi value
     * @return int|null
     */
    public function getKullanimSayisi()
    {
        return $this->KullanimSayisi;
    }
    /**
     * Set KullanimSayisi value
     * @param int $kullanimSayisi
     * @return \StructType\WebKampanyaHediyeCeki
     */
    public function setKullanimSayisi($kullanimSayisi = null)
    {
        // validation for constraint: int
        if (!is_null($kullanimSayisi) && !(is_int($kullanimSayisi) || ctype_digit($kullanimSayisi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kullanimSayisi, true), gettype($kullanimSayisi)), __LINE__);
        }
        $this->KullanimSayisi = $kullanimSayisi;
        return $this;
    }
    /**
     * Get Markalar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebKampanyaIDTanim|null
     */
    public function getMarkalar()
    {
        return isset($this->Markalar) ? $this->Markalar : null;
    }
    /**
     * Set Markalar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $markalar
     * @return \StructType\WebKampanyaHediyeCeki
     */
    public function setMarkalar(\ArrayType\ArrayOfWebKampanyaIDTanim $markalar = null)
    {
        if (is_null($markalar) || (is_array($markalar) && empty($markalar))) {
            unset($this->Markalar);
        } else {
            $this->Markalar = $markalar;
        }
        return $this;
    }
    /**
     * Get MinimumSepetTutari value
     * @return float|null
     */
    public function getMinimumSepetTutari()
    {
        return $this->MinimumSepetTutari;
    }
    /**
     * Set MinimumSepetTutari value
     * @param float $minimumSepetTutari
     * @return \StructType\WebKampanyaHediyeCeki
     */
    public function setMinimumSepetTutari($minimumSepetTutari = null)
    {
        // validation for constraint: float
        if (!is_null($minimumSepetTutari) && !(is_float($minimumSepetTutari) || is_numeric($minimumSepetTutari))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimumSepetTutari, true), gettype($minimumSepetTutari)), __LINE__);
        }
        $this->MinimumSepetTutari = $minimumSepetTutari;
        return $this;
    }
    /**
     * Get SiparisTarihineGoreOlustur value
     * @return bool|null
     */
    public function getSiparisTarihineGoreOlustur()
    {
        return $this->SiparisTarihineGoreOlustur;
    }
    /**
     * Set SiparisTarihineGoreOlustur value
     * @param bool $siparisTarihineGoreOlustur
     * @return \StructType\WebKampanyaHediyeCeki
     */
    public function setSiparisTarihineGoreOlustur($siparisTarihineGoreOlustur = null)
    {
        // validation for constraint: boolean
        if (!is_null($siparisTarihineGoreOlustur) && !is_bool($siparisTarihineGoreOlustur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($siparisTarihineGoreOlustur, true), gettype($siparisTarihineGoreOlustur)), __LINE__);
        }
        $this->SiparisTarihineGoreOlustur = $siparisTarihineGoreOlustur;
        return $this;
    }
    /**
     * Get UyeMaksKullanimSayisi value
     * @return int|null
     */
    public function getUyeMaksKullanimSayisi()
    {
        return $this->UyeMaksKullanimSayisi;
    }
    /**
     * Set UyeMaksKullanimSayisi value
     * @param int $uyeMaksKullanimSayisi
     * @return \StructType\WebKampanyaHediyeCeki
     */
    public function setUyeMaksKullanimSayisi($uyeMaksKullanimSayisi = null)
    {
        // validation for constraint: int
        if (!is_null($uyeMaksKullanimSayisi) && !(is_int($uyeMaksKullanimSayisi) || ctype_digit($uyeMaksKullanimSayisi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uyeMaksKullanimSayisi, true), gettype($uyeMaksKullanimSayisi)), __LINE__);
        }
        $this->UyeMaksKullanimSayisi = $uyeMaksKullanimSayisi;
        return $this;
    }
}
