<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveFavoriUrunResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RemoveFavoriUrunResponse
 * @subpackage Structs
 */
class RemoveFavoriUrunResponse extends AbstractStructBase
{
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The IsError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsError;
    /**
     * The RemoveFavoriUrunResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RemoveFavoriUrunResponse
     */
    public $RemoveFavoriUrunResult;
    /**
     * Constructor method for RemoveFavoriUrunResponse
     * @uses RemoveFavoriUrunResponse::setErrorMessage()
     * @uses RemoveFavoriUrunResponse::setIsError()
     * @uses RemoveFavoriUrunResponse::setRemoveFavoriUrunResult()
     * @param string $errorMessage
     * @param bool $isError
     * @param \StructType\RemoveFavoriUrunResponse $removeFavoriUrunResult
     */
    public function __construct($errorMessage = null, $isError = null, \StructType\RemoveFavoriUrunResponse $removeFavoriUrunResult = null)
    {
        $this
            ->setErrorMessage($errorMessage)
            ->setIsError($isError)
            ->setRemoveFavoriUrunResult($removeFavoriUrunResult);
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\RemoveFavoriUrunResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get IsError value
     * @return bool|null
     */
    public function getIsError()
    {
        return $this->IsError;
    }
    /**
     * Set IsError value
     * @param bool $isError
     * @return \StructType\RemoveFavoriUrunResponse
     */
    public function setIsError($isError = null)
    {
        // validation for constraint: boolean
        if (!is_null($isError) && !is_bool($isError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isError, true), gettype($isError)), __LINE__);
        }
        $this->IsError = $isError;
        return $this;
    }
    /**
     * Get RemoveFavoriUrunResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RemoveFavoriUrunResponse|null
     */
    public function getRemoveFavoriUrunResult()
    {
        return isset($this->RemoveFavoriUrunResult) ? $this->RemoveFavoriUrunResult : null;
    }
    /**
     * Set RemoveFavoriUrunResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RemoveFavoriUrunResponse $removeFavoriUrunResult
     * @return \StructType\RemoveFavoriUrunResponse
     */
    public function setRemoveFavoriUrunResult(\StructType\RemoveFavoriUrunResponse $removeFavoriUrunResult = null)
    {
        if (is_null($removeFavoriUrunResult) || (is_array($removeFavoriUrunResult) && empty($removeFavoriUrunResult))) {
            unset($this->RemoveFavoriUrunResult);
        } else {
            $this->RemoveFavoriUrunResult = $removeFavoriUrunResult;
        }
        return $this;
    }
}
