<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OdemeBildirim StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OdemeBildirim
 * @subpackage Structs
 */
class OdemeBildirim extends AbstractStructBase
{
    /**
     * The Banka
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Banka;
    /**
     * The Durumlar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKeyValueOfintstring
     */
    public $Durumlar;
    /**
     * The Durumu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Durumu;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Notlar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notlar;
    /**
     * The SiparisID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisID;
    /**
     * The SiparisNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiparisNo;
    /**
     * The Tarih
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Tarih;
    /**
     * The Tutar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Tutar;
    /**
     * The Uye
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Uye;
    /**
     * Constructor method for OdemeBildirim
     * @uses OdemeBildirim::setBanka()
     * @uses OdemeBildirim::setDurumlar()
     * @uses OdemeBildirim::setDurumu()
     * @uses OdemeBildirim::setID()
     * @uses OdemeBildirim::setNotlar()
     * @uses OdemeBildirim::setSiparisID()
     * @uses OdemeBildirim::setSiparisNo()
     * @uses OdemeBildirim::setTarih()
     * @uses OdemeBildirim::setTutar()
     * @uses OdemeBildirim::setUye()
     * @param string $banka
     * @param \ArrayType\ArrayOfKeyValueOfintstring $durumlar
     * @param int $durumu
     * @param int $iD
     * @param string $notlar
     * @param int $siparisID
     * @param string $siparisNo
     * @param string $tarih
     * @param float $tutar
     * @param string $uye
     */
    public function __construct($banka = null, \ArrayType\ArrayOfKeyValueOfintstring $durumlar = null, $durumu = null, $iD = null, $notlar = null, $siparisID = null, $siparisNo = null, $tarih = null, $tutar = null, $uye = null)
    {
        $this
            ->setBanka($banka)
            ->setDurumlar($durumlar)
            ->setDurumu($durumu)
            ->setID($iD)
            ->setNotlar($notlar)
            ->setSiparisID($siparisID)
            ->setSiparisNo($siparisNo)
            ->setTarih($tarih)
            ->setTutar($tutar)
            ->setUye($uye);
    }
    /**
     * Get Banka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBanka()
    {
        return isset($this->Banka) ? $this->Banka : null;
    }
    /**
     * Set Banka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $banka
     * @return \StructType\OdemeBildirim
     */
    public function setBanka($banka = null)
    {
        // validation for constraint: string
        if (!is_null($banka) && !is_string($banka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($banka, true), gettype($banka)), __LINE__);
        }
        if (is_null($banka) || (is_array($banka) && empty($banka))) {
            unset($this->Banka);
        } else {
            $this->Banka = $banka;
        }
        return $this;
    }
    /**
     * Get Durumlar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKeyValueOfintstring|null
     */
    public function getDurumlar()
    {
        return isset($this->Durumlar) ? $this->Durumlar : null;
    }
    /**
     * Set Durumlar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKeyValueOfintstring $durumlar
     * @return \StructType\OdemeBildirim
     */
    public function setDurumlar(\ArrayType\ArrayOfKeyValueOfintstring $durumlar = null)
    {
        if (is_null($durumlar) || (is_array($durumlar) && empty($durumlar))) {
            unset($this->Durumlar);
        } else {
            $this->Durumlar = $durumlar;
        }
        return $this;
    }
    /**
     * Get Durumu value
     * @return int|null
     */
    public function getDurumu()
    {
        return $this->Durumu;
    }
    /**
     * Set Durumu value
     * @param int $durumu
     * @return \StructType\OdemeBildirim
     */
    public function setDurumu($durumu = null)
    {
        // validation for constraint: int
        if (!is_null($durumu) && !(is_int($durumu) || ctype_digit($durumu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($durumu, true), gettype($durumu)), __LINE__);
        }
        $this->Durumu = $durumu;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\OdemeBildirim
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Notlar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotlar()
    {
        return isset($this->Notlar) ? $this->Notlar : null;
    }
    /**
     * Set Notlar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notlar
     * @return \StructType\OdemeBildirim
     */
    public function setNotlar($notlar = null)
    {
        // validation for constraint: string
        if (!is_null($notlar) && !is_string($notlar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notlar, true), gettype($notlar)), __LINE__);
        }
        if (is_null($notlar) || (is_array($notlar) && empty($notlar))) {
            unset($this->Notlar);
        } else {
            $this->Notlar = $notlar;
        }
        return $this;
    }
    /**
     * Get SiparisID value
     * @return int|null
     */
    public function getSiparisID()
    {
        return $this->SiparisID;
    }
    /**
     * Set SiparisID value
     * @param int $siparisID
     * @return \StructType\OdemeBildirim
     */
    public function setSiparisID($siparisID = null)
    {
        // validation for constraint: int
        if (!is_null($siparisID) && !(is_int($siparisID) || ctype_digit($siparisID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisID, true), gettype($siparisID)), __LINE__);
        }
        $this->SiparisID = $siparisID;
        return $this;
    }
    /**
     * Get SiparisNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiparisNo()
    {
        return isset($this->SiparisNo) ? $this->SiparisNo : null;
    }
    /**
     * Set SiparisNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siparisNo
     * @return \StructType\OdemeBildirim
     */
    public function setSiparisNo($siparisNo = null)
    {
        // validation for constraint: string
        if (!is_null($siparisNo) && !is_string($siparisNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siparisNo, true), gettype($siparisNo)), __LINE__);
        }
        if (is_null($siparisNo) || (is_array($siparisNo) && empty($siparisNo))) {
            unset($this->SiparisNo);
        } else {
            $this->SiparisNo = $siparisNo;
        }
        return $this;
    }
    /**
     * Get Tarih value
     * @return string|null
     */
    public function getTarih()
    {
        return $this->Tarih;
    }
    /**
     * Set Tarih value
     * @param string $tarih
     * @return \StructType\OdemeBildirim
     */
    public function setTarih($tarih = null)
    {
        // validation for constraint: string
        if (!is_null($tarih) && !is_string($tarih)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tarih, true), gettype($tarih)), __LINE__);
        }
        $this->Tarih = $tarih;
        return $this;
    }
    /**
     * Get Tutar value
     * @return float|null
     */
    public function getTutar()
    {
        return $this->Tutar;
    }
    /**
     * Set Tutar value
     * @param float $tutar
     * @return \StructType\OdemeBildirim
     */
    public function setTutar($tutar = null)
    {
        // validation for constraint: float
        if (!is_null($tutar) && !(is_float($tutar) || is_numeric($tutar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tutar, true), gettype($tutar)), __LINE__);
        }
        $this->Tutar = $tutar;
        return $this;
    }
    /**
     * Get Uye value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUye()
    {
        return isset($this->Uye) ? $this->Uye : null;
    }
    /**
     * Set Uye value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uye
     * @return \StructType\OdemeBildirim
     */
    public function setUye($uye = null)
    {
        // validation for constraint: string
        if (!is_null($uye) && !is_string($uye)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uye, true), gettype($uye)), __LINE__);
        }
        if (is_null($uye) || (is_array($uye) && empty($uye))) {
            unset($this->Uye);
        } else {
            $this->Uye = $uye;
        }
        return $this;
    }
}
