<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SaveEntegrasyonId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveEntegrasyonId $parameters
     * @return \StructType\SaveEntegrasyonIdResponse|bool
     */
    public function SaveEntegrasyonId(\StructType\SaveEntegrasyonId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveEntegrasyonId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveMenu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveMenu $parameters
     * @return \StructType\SaveMenuResponse|bool
     */
    public function SaveMenu(\StructType\SaveMenu $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveMenu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveSupportTicket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveSupportTicket $parameters
     * @return \StructType\SaveSupportTicketResponse|bool
     */
    public function SaveSupportTicket(\StructType\SaveSupportTicket $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveSupportTicket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveSupportTicketAnswer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveSupportTicketAnswer $parameters
     * @return \StructType\SaveSupportTicketAnswerResponse|bool
     */
    public function SaveSupportTicketAnswer(\StructType\SaveSupportTicketAnswer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveSupportTicketAnswer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveMailList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveMailList $parameters
     * @return \StructType\SaveMailListResponse|bool
     */
    public function SaveMailList(\StructType\SaveMailList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveMailList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveWebhook
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveWebhook $parameters
     * @return \StructType\SaveWebhookResponse|bool
     */
    public function SaveWebhook(\StructType\SaveWebhook $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveWebhook($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveOdemeBildirimDurum
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveOdemeBildirimDurum $parameters
     * @return \StructType\SaveOdemeBildirimDurumResponse|bool
     */
    public function SaveOdemeBildirimDurum(\StructType\SaveOdemeBildirimDurum $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveOdemeBildirimDurum($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SaveEntegrasyonIdResponse|\StructType\SaveMailListResponse|\StructType\SaveMenuResponse|\StructType\SaveOdemeBildirimDurumResponse|\StructType\SaveSupportTicketAnswerResponse|\StructType\SaveSupportTicketResponse|\StructType\SaveWebhookResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
