<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWebhook ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfWebhook
 * @subpackage Arrays
 */
class ArrayOfWebhook extends AbstractStructArrayBase
{
    /**
     * The Webhook
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Webhook[]
     */
    public $Webhook;
    /**
     * Constructor method for ArrayOfWebhook
     * @uses ArrayOfWebhook::setWebhook()
     * @param \StructType\Webhook[] $webhook
     */
    public function __construct(array $webhook = array())
    {
        $this
            ->setWebhook($webhook);
    }
    /**
     * Get Webhook value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Webhook[]|null
     */
    public function getWebhook()
    {
        return isset($this->Webhook) ? $this->Webhook : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWebhook method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWebhook method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWebhookForArrayConstraintsFromSetWebhook(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWebhookWebhookItem) {
            // validation for constraint: itemType
            if (!$arrayOfWebhookWebhookItem instanceof \StructType\Webhook) {
                $invalidValues[] = is_object($arrayOfWebhookWebhookItem) ? get_class($arrayOfWebhookWebhookItem) : sprintf('%s(%s)', gettype($arrayOfWebhookWebhookItem), var_export($arrayOfWebhookWebhookItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Webhook property can only contain items of type \StructType\Webhook, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Webhook value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Webhook[] $webhook
     * @return \ArrayType\ArrayOfWebhook
     */
    public function setWebhook(array $webhook = array())
    {
        // validation for constraint: array
        if ('' !== ($webhookArrayErrorMessage = self::validateWebhookForArrayConstraintsFromSetWebhook($webhook))) {
            throw new \InvalidArgumentException($webhookArrayErrorMessage, __LINE__);
        }
        if (is_null($webhook) || (is_array($webhook) && empty($webhook))) {
            unset($this->Webhook);
        } else {
            $this->Webhook = $webhook;
        }
        return $this;
    }
    /**
     * Add item to Webhook value
     * @throws \InvalidArgumentException
     * @param \StructType\Webhook $item
     * @return \ArrayType\ArrayOfWebhook
     */
    public function addToWebhook(\StructType\Webhook $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Webhook) {
            throw new \InvalidArgumentException(sprintf('The Webhook property can only contain items of type \StructType\Webhook, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Webhook[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Webhook|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Webhook|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Webhook|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Webhook|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Webhook|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Webhook
     */
    public function getAttributeName()
    {
        return 'Webhook';
    }
}
