<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWebBanka ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfWebBanka
 * @subpackage Arrays
 */
class ArrayOfWebBanka extends AbstractStructArrayBase
{
    /**
     * The WebBanka
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WebBanka[]
     */
    public $WebBanka;
    /**
     * Constructor method for ArrayOfWebBanka
     * @uses ArrayOfWebBanka::setWebBanka()
     * @param \StructType\WebBanka[] $webBanka
     */
    public function __construct(array $webBanka = array())
    {
        $this
            ->setWebBanka($webBanka);
    }
    /**
     * Get WebBanka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WebBanka[]|null
     */
    public function getWebBanka()
    {
        return isset($this->WebBanka) ? $this->WebBanka : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWebBanka method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWebBanka method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWebBankaForArrayConstraintsFromSetWebBanka(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWebBankaWebBankaItem) {
            // validation for constraint: itemType
            if (!$arrayOfWebBankaWebBankaItem instanceof \StructType\WebBanka) {
                $invalidValues[] = is_object($arrayOfWebBankaWebBankaItem) ? get_class($arrayOfWebBankaWebBankaItem) : sprintf('%s(%s)', gettype($arrayOfWebBankaWebBankaItem), var_export($arrayOfWebBankaWebBankaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WebBanka property can only contain items of type \StructType\WebBanka, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WebBanka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WebBanka[] $webBanka
     * @return \ArrayType\ArrayOfWebBanka
     */
    public function setWebBanka(array $webBanka = array())
    {
        // validation for constraint: array
        if ('' !== ($webBankaArrayErrorMessage = self::validateWebBankaForArrayConstraintsFromSetWebBanka($webBanka))) {
            throw new \InvalidArgumentException($webBankaArrayErrorMessage, __LINE__);
        }
        if (is_null($webBanka) || (is_array($webBanka) && empty($webBanka))) {
            unset($this->WebBanka);
        } else {
            $this->WebBanka = $webBanka;
        }
        return $this;
    }
    /**
     * Add item to WebBanka value
     * @throws \InvalidArgumentException
     * @param \StructType\WebBanka $item
     * @return \ArrayType\ArrayOfWebBanka
     */
    public function addToWebBanka(\StructType\WebBanka $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WebBanka) {
            throw new \InvalidArgumentException(sprintf('The WebBanka property can only contain items of type \StructType\WebBanka, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WebBanka[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WebBanka|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WebBanka|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WebBanka|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WebBanka|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WebBanka|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WebBanka
     */
    public function getAttributeName()
    {
        return 'WebBanka';
    }
}
