<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebKampanyaTicimax StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebKampanyaTicimax
 * @subpackage Structs
 */
class WebKampanyaTicimax extends AbstractStructBase
{
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Aciklama;
    /**
     * The AndroidAktif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AndroidAktif;
    /**
     * The BaslangicTarihi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BaslangicTarihi;
    /**
     * The BitisTarihi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BitisTarihi;
    /**
     * The DuzenlemeTarihi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DuzenlemeTarihi;
    /**
     * The DuzenleyenKullanici
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DuzenleyenKullanici;
    /**
     * The EklemeTarihi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EklemeTarihi;
    /**
     * The EkleyenKullanici
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EkleyenKullanici;
    /**
     * The GunKosulu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GunKosulu;
    /**
     * The Gunler
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebKampanyaIDTanim
     */
    public $Gunler;
    /**
     * The Hediyeler
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WebKampanyaHediye
     */
    public $Hediyeler;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The IOSAktif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IOSAktif;
    /**
     * The IslemDegeri
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $IslemDegeri;
    /**
     * The IslemTipi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IslemTipi;
    /**
     * The Kosullar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WebKampanyaKosul
     */
    public $Kosullar;
    /**
     * The MaksSiparisSayisi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaksSiparisSayisi;
    /**
     * The MinAlisverisTutari
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MinAlisverisTutari;
    /**
     * The MinUrunAdedi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinUrunAdedi;
    /**
     * The MobilAktif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MobilAktif;
    /**
     * The Oncelik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Oncelik;
    /**
     * The Parabirimi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Parabirimi;
    /**
     * The SaatAraliklari
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebKampanyaSaatAraligi
     */
    public $SaatAraliklari;
    /**
     * The Sablon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Sablon;
    /**
     * The SepetteAciklamaGoster
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SepetteAciklamaGoster;
    /**
     * The Tanim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tanim;
    /**
     * The TekrarDegeri
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TekrarDegeri;
    /**
     * The Tip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tip;
    /**
     * The Ulke
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ulke;
    /**
     * The UyeMaksKullanimSayisi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UyeMaksKullanimSayisi;
    /**
     * The Uyeler
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebKampanyaUye
     */
    public $Uyeler;
    /**
     * The UygulamaYontemleri
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WebKampanyaUygulamaYontemi
     */
    public $UygulamaYontemleri;
    /**
     * The WebAktif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $WebAktif;
    /**
     * Constructor method for WebKampanyaTicimax
     * @uses WebKampanyaTicimax::setAciklama()
     * @uses WebKampanyaTicimax::setAndroidAktif()
     * @uses WebKampanyaTicimax::setBaslangicTarihi()
     * @uses WebKampanyaTicimax::setBitisTarihi()
     * @uses WebKampanyaTicimax::setDuzenlemeTarihi()
     * @uses WebKampanyaTicimax::setDuzenleyenKullanici()
     * @uses WebKampanyaTicimax::setEklemeTarihi()
     * @uses WebKampanyaTicimax::setEkleyenKullanici()
     * @uses WebKampanyaTicimax::setGunKosulu()
     * @uses WebKampanyaTicimax::setGunler()
     * @uses WebKampanyaTicimax::setHediyeler()
     * @uses WebKampanyaTicimax::setID()
     * @uses WebKampanyaTicimax::setIOSAktif()
     * @uses WebKampanyaTicimax::setIslemDegeri()
     * @uses WebKampanyaTicimax::setIslemTipi()
     * @uses WebKampanyaTicimax::setKosullar()
     * @uses WebKampanyaTicimax::setMaksSiparisSayisi()
     * @uses WebKampanyaTicimax::setMinAlisverisTutari()
     * @uses WebKampanyaTicimax::setMinUrunAdedi()
     * @uses WebKampanyaTicimax::setMobilAktif()
     * @uses WebKampanyaTicimax::setOncelik()
     * @uses WebKampanyaTicimax::setParabirimi()
     * @uses WebKampanyaTicimax::setSaatAraliklari()
     * @uses WebKampanyaTicimax::setSablon()
     * @uses WebKampanyaTicimax::setSepetteAciklamaGoster()
     * @uses WebKampanyaTicimax::setTanim()
     * @uses WebKampanyaTicimax::setTekrarDegeri()
     * @uses WebKampanyaTicimax::setTip()
     * @uses WebKampanyaTicimax::setUlke()
     * @uses WebKampanyaTicimax::setUyeMaksKullanimSayisi()
     * @uses WebKampanyaTicimax::setUyeler()
     * @uses WebKampanyaTicimax::setUygulamaYontemleri()
     * @uses WebKampanyaTicimax::setWebAktif()
     * @param string $aciklama
     * @param bool $androidAktif
     * @param string $baslangicTarihi
     * @param string $bitisTarihi
     * @param string $duzenlemeTarihi
     * @param int $duzenleyenKullanici
     * @param string $eklemeTarihi
     * @param int $ekleyenKullanici
     * @param int $gunKosulu
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $gunler
     * @param \StructType\WebKampanyaHediye $hediyeler
     * @param int $iD
     * @param bool $iOSAktif
     * @param float $islemDegeri
     * @param int $islemTipi
     * @param \StructType\WebKampanyaKosul $kosullar
     * @param int $maksSiparisSayisi
     * @param float $minAlisverisTutari
     * @param int $minUrunAdedi
     * @param bool $mobilAktif
     * @param int $oncelik
     * @param string $parabirimi
     * @param \ArrayType\ArrayOfWebKampanyaSaatAraligi $saatAraliklari
     * @param bool $sablon
     * @param bool $sepetteAciklamaGoster
     * @param string $tanim
     * @param float $tekrarDegeri
     * @param int $tip
     * @param string $ulke
     * @param int $uyeMaksKullanimSayisi
     * @param \ArrayType\ArrayOfWebKampanyaUye $uyeler
     * @param \StructType\WebKampanyaUygulamaYontemi $uygulamaYontemleri
     * @param bool $webAktif
     */
    public function __construct($aciklama = null, $androidAktif = null, $baslangicTarihi = null, $bitisTarihi = null, $duzenlemeTarihi = null, $duzenleyenKullanici = null, $eklemeTarihi = null, $ekleyenKullanici = null, $gunKosulu = null, \ArrayType\ArrayOfWebKampanyaIDTanim $gunler = null, \StructType\WebKampanyaHediye $hediyeler = null, $iD = null, $iOSAktif = null, $islemDegeri = null, $islemTipi = null, \StructType\WebKampanyaKosul $kosullar = null, $maksSiparisSayisi = null, $minAlisverisTutari = null, $minUrunAdedi = null, $mobilAktif = null, $oncelik = null, $parabirimi = null, \ArrayType\ArrayOfWebKampanyaSaatAraligi $saatAraliklari = null, $sablon = null, $sepetteAciklamaGoster = null, $tanim = null, $tekrarDegeri = null, $tip = null, $ulke = null, $uyeMaksKullanimSayisi = null, \ArrayType\ArrayOfWebKampanyaUye $uyeler = null, \StructType\WebKampanyaUygulamaYontemi $uygulamaYontemleri = null, $webAktif = null)
    {
        $this
            ->setAciklama($aciklama)
            ->setAndroidAktif($androidAktif)
            ->setBaslangicTarihi($baslangicTarihi)
            ->setBitisTarihi($bitisTarihi)
            ->setDuzenlemeTarihi($duzenlemeTarihi)
            ->setDuzenleyenKullanici($duzenleyenKullanici)
            ->setEklemeTarihi($eklemeTarihi)
            ->setEkleyenKullanici($ekleyenKullanici)
            ->setGunKosulu($gunKosulu)
            ->setGunler($gunler)
            ->setHediyeler($hediyeler)
            ->setID($iD)
            ->setIOSAktif($iOSAktif)
            ->setIslemDegeri($islemDegeri)
            ->setIslemTipi($islemTipi)
            ->setKosullar($kosullar)
            ->setMaksSiparisSayisi($maksSiparisSayisi)
            ->setMinAlisverisTutari($minAlisverisTutari)
            ->setMinUrunAdedi($minUrunAdedi)
            ->setMobilAktif($mobilAktif)
            ->setOncelik($oncelik)
            ->setParabirimi($parabirimi)
            ->setSaatAraliklari($saatAraliklari)
            ->setSablon($sablon)
            ->setSepetteAciklamaGoster($sepetteAciklamaGoster)
            ->setTanim($tanim)
            ->setTekrarDegeri($tekrarDegeri)
            ->setTip($tip)
            ->setUlke($ulke)
            ->setUyeMaksKullanimSayisi($uyeMaksKullanimSayisi)
            ->setUyeler($uyeler)
            ->setUygulamaYontemleri($uygulamaYontemleri)
            ->setWebAktif($webAktif);
    }
    /**
     * Get Aciklama value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAciklama()
    {
        return isset($this->Aciklama) ? $this->Aciklama : null;
    }
    /**
     * Set Aciklama value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aciklama
     * @return \StructType\WebKampanyaTicimax
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        if (is_null($aciklama) || (is_array($aciklama) && empty($aciklama))) {
            unset($this->Aciklama);
        } else {
            $this->Aciklama = $aciklama;
        }
        return $this;
    }
    /**
     * Get AndroidAktif value
     * @return bool|null
     */
    public function getAndroidAktif()
    {
        return $this->AndroidAktif;
    }
    /**
     * Set AndroidAktif value
     * @param bool $androidAktif
     * @return \StructType\WebKampanyaTicimax
     */
    public function setAndroidAktif($androidAktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($androidAktif) && !is_bool($androidAktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($androidAktif, true), gettype($androidAktif)), __LINE__);
        }
        $this->AndroidAktif = $androidAktif;
        return $this;
    }
    /**
     * Get BaslangicTarihi value
     * @return string|null
     */
    public function getBaslangicTarihi()
    {
        return $this->BaslangicTarihi;
    }
    /**
     * Set BaslangicTarihi value
     * @param string $baslangicTarihi
     * @return \StructType\WebKampanyaTicimax
     */
    public function setBaslangicTarihi($baslangicTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($baslangicTarihi) && !is_string($baslangicTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baslangicTarihi, true), gettype($baslangicTarihi)), __LINE__);
        }
        $this->BaslangicTarihi = $baslangicTarihi;
        return $this;
    }
    /**
     * Get BitisTarihi value
     * @return string|null
     */
    public function getBitisTarihi()
    {
        return $this->BitisTarihi;
    }
    /**
     * Set BitisTarihi value
     * @param string $bitisTarihi
     * @return \StructType\WebKampanyaTicimax
     */
    public function setBitisTarihi($bitisTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($bitisTarihi) && !is_string($bitisTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bitisTarihi, true), gettype($bitisTarihi)), __LINE__);
        }
        $this->BitisTarihi = $bitisTarihi;
        return $this;
    }
    /**
     * Get DuzenlemeTarihi value
     * @return string|null
     */
    public function getDuzenlemeTarihi()
    {
        return $this->DuzenlemeTarihi;
    }
    /**
     * Set DuzenlemeTarihi value
     * @param string $duzenlemeTarihi
     * @return \StructType\WebKampanyaTicimax
     */
    public function setDuzenlemeTarihi($duzenlemeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($duzenlemeTarihi) && !is_string($duzenlemeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duzenlemeTarihi, true), gettype($duzenlemeTarihi)), __LINE__);
        }
        $this->DuzenlemeTarihi = $duzenlemeTarihi;
        return $this;
    }
    /**
     * Get DuzenleyenKullanici value
     * @return int|null
     */
    public function getDuzenleyenKullanici()
    {
        return $this->DuzenleyenKullanici;
    }
    /**
     * Set DuzenleyenKullanici value
     * @param int $duzenleyenKullanici
     * @return \StructType\WebKampanyaTicimax
     */
    public function setDuzenleyenKullanici($duzenleyenKullanici = null)
    {
        // validation for constraint: int
        if (!is_null($duzenleyenKullanici) && !(is_int($duzenleyenKullanici) || ctype_digit($duzenleyenKullanici))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duzenleyenKullanici, true), gettype($duzenleyenKullanici)), __LINE__);
        }
        $this->DuzenleyenKullanici = $duzenleyenKullanici;
        return $this;
    }
    /**
     * Get EklemeTarihi value
     * @return string|null
     */
    public function getEklemeTarihi()
    {
        return $this->EklemeTarihi;
    }
    /**
     * Set EklemeTarihi value
     * @param string $eklemeTarihi
     * @return \StructType\WebKampanyaTicimax
     */
    public function setEklemeTarihi($eklemeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($eklemeTarihi) && !is_string($eklemeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eklemeTarihi, true), gettype($eklemeTarihi)), __LINE__);
        }
        $this->EklemeTarihi = $eklemeTarihi;
        return $this;
    }
    /**
     * Get EkleyenKullanici value
     * @return int|null
     */
    public function getEkleyenKullanici()
    {
        return $this->EkleyenKullanici;
    }
    /**
     * Set EkleyenKullanici value
     * @param int $ekleyenKullanici
     * @return \StructType\WebKampanyaTicimax
     */
    public function setEkleyenKullanici($ekleyenKullanici = null)
    {
        // validation for constraint: int
        if (!is_null($ekleyenKullanici) && !(is_int($ekleyenKullanici) || ctype_digit($ekleyenKullanici))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ekleyenKullanici, true), gettype($ekleyenKullanici)), __LINE__);
        }
        $this->EkleyenKullanici = $ekleyenKullanici;
        return $this;
    }
    /**
     * Get GunKosulu value
     * @return int|null
     */
    public function getGunKosulu()
    {
        return $this->GunKosulu;
    }
    /**
     * Set GunKosulu value
     * @param int $gunKosulu
     * @return \StructType\WebKampanyaTicimax
     */
    public function setGunKosulu($gunKosulu = null)
    {
        // validation for constraint: int
        if (!is_null($gunKosulu) && !(is_int($gunKosulu) || ctype_digit($gunKosulu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gunKosulu, true), gettype($gunKosulu)), __LINE__);
        }
        $this->GunKosulu = $gunKosulu;
        return $this;
    }
    /**
     * Get Gunler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebKampanyaIDTanim|null
     */
    public function getGunler()
    {
        return isset($this->Gunler) ? $this->Gunler : null;
    }
    /**
     * Set Gunler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $gunler
     * @return \StructType\WebKampanyaTicimax
     */
    public function setGunler(\ArrayType\ArrayOfWebKampanyaIDTanim $gunler = null)
    {
        if (is_null($gunler) || (is_array($gunler) && empty($gunler))) {
            unset($this->Gunler);
        } else {
            $this->Gunler = $gunler;
        }
        return $this;
    }
    /**
     * Get Hediyeler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WebKampanyaHediye|null
     */
    public function getHediyeler()
    {
        return isset($this->Hediyeler) ? $this->Hediyeler : null;
    }
    /**
     * Set Hediyeler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WebKampanyaHediye $hediyeler
     * @return \StructType\WebKampanyaTicimax
     */
    public function setHediyeler(\StructType\WebKampanyaHediye $hediyeler = null)
    {
        if (is_null($hediyeler) || (is_array($hediyeler) && empty($hediyeler))) {
            unset($this->Hediyeler);
        } else {
            $this->Hediyeler = $hediyeler;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\WebKampanyaTicimax
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IOSAktif value
     * @return bool|null
     */
    public function getIOSAktif()
    {
        return $this->IOSAktif;
    }
    /**
     * Set IOSAktif value
     * @param bool $iOSAktif
     * @return \StructType\WebKampanyaTicimax
     */
    public function setIOSAktif($iOSAktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($iOSAktif) && !is_bool($iOSAktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($iOSAktif, true), gettype($iOSAktif)), __LINE__);
        }
        $this->IOSAktif = $iOSAktif;
        return $this;
    }
    /**
     * Get IslemDegeri value
     * @return float|null
     */
    public function getIslemDegeri()
    {
        return $this->IslemDegeri;
    }
    /**
     * Set IslemDegeri value
     * @param float $islemDegeri
     * @return \StructType\WebKampanyaTicimax
     */
    public function setIslemDegeri($islemDegeri = null)
    {
        // validation for constraint: float
        if (!is_null($islemDegeri) && !(is_float($islemDegeri) || is_numeric($islemDegeri))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($islemDegeri, true), gettype($islemDegeri)), __LINE__);
        }
        $this->IslemDegeri = $islemDegeri;
        return $this;
    }
    /**
     * Get IslemTipi value
     * @return int|null
     */
    public function getIslemTipi()
    {
        return $this->IslemTipi;
    }
    /**
     * Set IslemTipi value
     * @param int $islemTipi
     * @return \StructType\WebKampanyaTicimax
     */
    public function setIslemTipi($islemTipi = null)
    {
        // validation for constraint: int
        if (!is_null($islemTipi) && !(is_int($islemTipi) || ctype_digit($islemTipi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($islemTipi, true), gettype($islemTipi)), __LINE__);
        }
        $this->IslemTipi = $islemTipi;
        return $this;
    }
    /**
     * Get Kosullar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WebKampanyaKosul|null
     */
    public function getKosullar()
    {
        return isset($this->Kosullar) ? $this->Kosullar : null;
    }
    /**
     * Set Kosullar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WebKampanyaKosul $kosullar
     * @return \StructType\WebKampanyaTicimax
     */
    public function setKosullar(\StructType\WebKampanyaKosul $kosullar = null)
    {
        if (is_null($kosullar) || (is_array($kosullar) && empty($kosullar))) {
            unset($this->Kosullar);
        } else {
            $this->Kosullar = $kosullar;
        }
        return $this;
    }
    /**
     * Get MaksSiparisSayisi value
     * @return int|null
     */
    public function getMaksSiparisSayisi()
    {
        return $this->MaksSiparisSayisi;
    }
    /**
     * Set MaksSiparisSayisi value
     * @param int $maksSiparisSayisi
     * @return \StructType\WebKampanyaTicimax
     */
    public function setMaksSiparisSayisi($maksSiparisSayisi = null)
    {
        // validation for constraint: int
        if (!is_null($maksSiparisSayisi) && !(is_int($maksSiparisSayisi) || ctype_digit($maksSiparisSayisi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maksSiparisSayisi, true), gettype($maksSiparisSayisi)), __LINE__);
        }
        $this->MaksSiparisSayisi = $maksSiparisSayisi;
        return $this;
    }
    /**
     * Get MinAlisverisTutari value
     * @return float|null
     */
    public function getMinAlisverisTutari()
    {
        return $this->MinAlisverisTutari;
    }
    /**
     * Set MinAlisverisTutari value
     * @param float $minAlisverisTutari
     * @return \StructType\WebKampanyaTicimax
     */
    public function setMinAlisverisTutari($minAlisverisTutari = null)
    {
        // validation for constraint: float
        if (!is_null($minAlisverisTutari) && !(is_float($minAlisverisTutari) || is_numeric($minAlisverisTutari))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minAlisverisTutari, true), gettype($minAlisverisTutari)), __LINE__);
        }
        $this->MinAlisverisTutari = $minAlisverisTutari;
        return $this;
    }
    /**
     * Get MinUrunAdedi value
     * @return int|null
     */
    public function getMinUrunAdedi()
    {
        return $this->MinUrunAdedi;
    }
    /**
     * Set MinUrunAdedi value
     * @param int $minUrunAdedi
     * @return \StructType\WebKampanyaTicimax
     */
    public function setMinUrunAdedi($minUrunAdedi = null)
    {
        // validation for constraint: int
        if (!is_null($minUrunAdedi) && !(is_int($minUrunAdedi) || ctype_digit($minUrunAdedi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minUrunAdedi, true), gettype($minUrunAdedi)), __LINE__);
        }
        $this->MinUrunAdedi = $minUrunAdedi;
        return $this;
    }
    /**
     * Get MobilAktif value
     * @return bool|null
     */
    public function getMobilAktif()
    {
        return $this->MobilAktif;
    }
    /**
     * Set MobilAktif value
     * @param bool $mobilAktif
     * @return \StructType\WebKampanyaTicimax
     */
    public function setMobilAktif($mobilAktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($mobilAktif) && !is_bool($mobilAktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mobilAktif, true), gettype($mobilAktif)), __LINE__);
        }
        $this->MobilAktif = $mobilAktif;
        return $this;
    }
    /**
     * Get Oncelik value
     * @return int|null
     */
    public function getOncelik()
    {
        return $this->Oncelik;
    }
    /**
     * Set Oncelik value
     * @param int $oncelik
     * @return \StructType\WebKampanyaTicimax
     */
    public function setOncelik($oncelik = null)
    {
        // validation for constraint: int
        if (!is_null($oncelik) && !(is_int($oncelik) || ctype_digit($oncelik))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oncelik, true), gettype($oncelik)), __LINE__);
        }
        $this->Oncelik = $oncelik;
        return $this;
    }
    /**
     * Get Parabirimi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParabirimi()
    {
        return isset($this->Parabirimi) ? $this->Parabirimi : null;
    }
    /**
     * Set Parabirimi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parabirimi
     * @return \StructType\WebKampanyaTicimax
     */
    public function setParabirimi($parabirimi = null)
    {
        // validation for constraint: string
        if (!is_null($parabirimi) && !is_string($parabirimi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parabirimi, true), gettype($parabirimi)), __LINE__);
        }
        if (is_null($parabirimi) || (is_array($parabirimi) && empty($parabirimi))) {
            unset($this->Parabirimi);
        } else {
            $this->Parabirimi = $parabirimi;
        }
        return $this;
    }
    /**
     * Get SaatAraliklari value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebKampanyaSaatAraligi|null
     */
    public function getSaatAraliklari()
    {
        return isset($this->SaatAraliklari) ? $this->SaatAraliklari : null;
    }
    /**
     * Set SaatAraliklari value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebKampanyaSaatAraligi $saatAraliklari
     * @return \StructType\WebKampanyaTicimax
     */
    public function setSaatAraliklari(\ArrayType\ArrayOfWebKampanyaSaatAraligi $saatAraliklari = null)
    {
        if (is_null($saatAraliklari) || (is_array($saatAraliklari) && empty($saatAraliklari))) {
            unset($this->SaatAraliklari);
        } else {
            $this->SaatAraliklari = $saatAraliklari;
        }
        return $this;
    }
    /**
     * Get Sablon value
     * @return bool|null
     */
    public function getSablon()
    {
        return $this->Sablon;
    }
    /**
     * Set Sablon value
     * @param bool $sablon
     * @return \StructType\WebKampanyaTicimax
     */
    public function setSablon($sablon = null)
    {
        // validation for constraint: boolean
        if (!is_null($sablon) && !is_bool($sablon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sablon, true), gettype($sablon)), __LINE__);
        }
        $this->Sablon = $sablon;
        return $this;
    }
    /**
     * Get SepetteAciklamaGoster value
     * @return bool|null
     */
    public function getSepetteAciklamaGoster()
    {
        return $this->SepetteAciklamaGoster;
    }
    /**
     * Set SepetteAciklamaGoster value
     * @param bool $sepetteAciklamaGoster
     * @return \StructType\WebKampanyaTicimax
     */
    public function setSepetteAciklamaGoster($sepetteAciklamaGoster = null)
    {
        // validation for constraint: boolean
        if (!is_null($sepetteAciklamaGoster) && !is_bool($sepetteAciklamaGoster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sepetteAciklamaGoster, true), gettype($sepetteAciklamaGoster)), __LINE__);
        }
        $this->SepetteAciklamaGoster = $sepetteAciklamaGoster;
        return $this;
    }
    /**
     * Get Tanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTanim()
    {
        return isset($this->Tanim) ? $this->Tanim : null;
    }
    /**
     * Set Tanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tanim
     * @return \StructType\WebKampanyaTicimax
     */
    public function setTanim($tanim = null)
    {
        // validation for constraint: string
        if (!is_null($tanim) && !is_string($tanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tanim, true), gettype($tanim)), __LINE__);
        }
        if (is_null($tanim) || (is_array($tanim) && empty($tanim))) {
            unset($this->Tanim);
        } else {
            $this->Tanim = $tanim;
        }
        return $this;
    }
    /**
     * Get TekrarDegeri value
     * @return float|null
     */
    public function getTekrarDegeri()
    {
        return $this->TekrarDegeri;
    }
    /**
     * Set TekrarDegeri value
     * @param float $tekrarDegeri
     * @return \StructType\WebKampanyaTicimax
     */
    public function setTekrarDegeri($tekrarDegeri = null)
    {
        // validation for constraint: float
        if (!is_null($tekrarDegeri) && !(is_float($tekrarDegeri) || is_numeric($tekrarDegeri))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tekrarDegeri, true), gettype($tekrarDegeri)), __LINE__);
        }
        $this->TekrarDegeri = $tekrarDegeri;
        return $this;
    }
    /**
     * Get Tip value
     * @return int|null
     */
    public function getTip()
    {
        return $this->Tip;
    }
    /**
     * Set Tip value
     * @param int $tip
     * @return \StructType\WebKampanyaTicimax
     */
    public function setTip($tip = null)
    {
        // validation for constraint: int
        if (!is_null($tip) && !(is_int($tip) || ctype_digit($tip))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tip, true), gettype($tip)), __LINE__);
        }
        $this->Tip = $tip;
        return $this;
    }
    /**
     * Get Ulke value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUlke()
    {
        return isset($this->Ulke) ? $this->Ulke : null;
    }
    /**
     * Set Ulke value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ulke
     * @return \StructType\WebKampanyaTicimax
     */
    public function setUlke($ulke = null)
    {
        // validation for constraint: string
        if (!is_null($ulke) && !is_string($ulke)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ulke, true), gettype($ulke)), __LINE__);
        }
        if (is_null($ulke) || (is_array($ulke) && empty($ulke))) {
            unset($this->Ulke);
        } else {
            $this->Ulke = $ulke;
        }
        return $this;
    }
    /**
     * Get UyeMaksKullanimSayisi value
     * @return int|null
     */
    public function getUyeMaksKullanimSayisi()
    {
        return $this->UyeMaksKullanimSayisi;
    }
    /**
     * Set UyeMaksKullanimSayisi value
     * @param int $uyeMaksKullanimSayisi
     * @return \StructType\WebKampanyaTicimax
     */
    public function setUyeMaksKullanimSayisi($uyeMaksKullanimSayisi = null)
    {
        // validation for constraint: int
        if (!is_null($uyeMaksKullanimSayisi) && !(is_int($uyeMaksKullanimSayisi) || ctype_digit($uyeMaksKullanimSayisi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uyeMaksKullanimSayisi, true), gettype($uyeMaksKullanimSayisi)), __LINE__);
        }
        $this->UyeMaksKullanimSayisi = $uyeMaksKullanimSayisi;
        return $this;
    }
    /**
     * Get Uyeler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebKampanyaUye|null
     */
    public function getUyeler()
    {
        return isset($this->Uyeler) ? $this->Uyeler : null;
    }
    /**
     * Set Uyeler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebKampanyaUye $uyeler
     * @return \StructType\WebKampanyaTicimax
     */
    public function setUyeler(\ArrayType\ArrayOfWebKampanyaUye $uyeler = null)
    {
        if (is_null($uyeler) || (is_array($uyeler) && empty($uyeler))) {
            unset($this->Uyeler);
        } else {
            $this->Uyeler = $uyeler;
        }
        return $this;
    }
    /**
     * Get UygulamaYontemleri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WebKampanyaUygulamaYontemi|null
     */
    public function getUygulamaYontemleri()
    {
        return isset($this->UygulamaYontemleri) ? $this->UygulamaYontemleri : null;
    }
    /**
     * Set UygulamaYontemleri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WebKampanyaUygulamaYontemi $uygulamaYontemleri
     * @return \StructType\WebKampanyaTicimax
     */
    public function setUygulamaYontemleri(\StructType\WebKampanyaUygulamaYontemi $uygulamaYontemleri = null)
    {
        if (is_null($uygulamaYontemleri) || (is_array($uygulamaYontemleri) && empty($uygulamaYontemleri))) {
            unset($this->UygulamaYontemleri);
        } else {
            $this->UygulamaYontemleri = $uygulamaYontemleri;
        }
        return $this;
    }
    /**
     * Get WebAktif value
     * @return bool|null
     */
    public function getWebAktif()
    {
        return $this->WebAktif;
    }
    /**
     * Set WebAktif value
     * @param bool $webAktif
     * @return \StructType\WebKampanyaTicimax
     */
    public function setWebAktif($webAktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($webAktif) && !is_bool($webAktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($webAktif, true), gettype($webAktif)), __LINE__);
        }
        $this->WebAktif = $webAktif;
        return $this;
    }
}
