<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectBanka StructType
 * @subpackage Structs
 */
class SelectBanka extends AbstractStructBase
{
    /**
     * The UyeKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UyeKodu;
    /**
     * The BankaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BankaID;
    /**
     * Constructor method for SelectBanka
     * @uses SelectBanka::setUyeKodu()
     * @uses SelectBanka::setBankaID()
     * @param string $uyeKodu
     * @param int $bankaID
     */
    public function __construct($uyeKodu = null, $bankaID = null)
    {
        $this
            ->setUyeKodu($uyeKodu)
            ->setBankaID($bankaID);
    }
    /**
     * Get UyeKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUyeKodu()
    {
        return isset($this->UyeKodu) ? $this->UyeKodu : null;
    }
    /**
     * Set UyeKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uyeKodu
     * @return \StructType\SelectBanka
     */
    public function setUyeKodu($uyeKodu = null)
    {
        // validation for constraint: string
        if (!is_null($uyeKodu) && !is_string($uyeKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uyeKodu, true), gettype($uyeKodu)), __LINE__);
        }
        if (is_null($uyeKodu) || (is_array($uyeKodu) && empty($uyeKodu))) {
            unset($this->UyeKodu);
        } else {
            $this->UyeKodu = $uyeKodu;
        }
        return $this;
    }
    /**
     * Get BankaID value
     * @return int|null
     */
    public function getBankaID()
    {
        return $this->BankaID;
    }
    /**
     * Set BankaID value
     * @param int $bankaID
     * @return \StructType\SelectBanka
     */
    public function setBankaID($bankaID = null)
    {
        // validation for constraint: int
        if (!is_null($bankaID) && !(is_int($bankaID) || ctype_digit($bankaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bankaID, true), gettype($bankaID)), __LINE__);
        }
        $this->BankaID = $bankaID;
        return $this;
    }
}
