<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DinamikFormData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DinamikFormData
 * @subpackage Structs
 */
class DinamikFormData extends AbstractStructBase
{
    /**
     * The DataList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfFormDataModel
     */
    public $DataList;
    /**
     * The EklenmeTarihi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EklenmeTarihi;
    /**
     * The FormId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FormId;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The UyeAdi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UyeAdi;
    /**
     * The UyeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UyeID;
    /**
     * Constructor method for DinamikFormData
     * @uses DinamikFormData::setDataList()
     * @uses DinamikFormData::setEklenmeTarihi()
     * @uses DinamikFormData::setFormId()
     * @uses DinamikFormData::setID()
     * @uses DinamikFormData::setUyeAdi()
     * @uses DinamikFormData::setUyeID()
     * @param \ArrayType\ArrayOfFormDataModel $dataList
     * @param string $eklenmeTarihi
     * @param int $formId
     * @param int $iD
     * @param string $uyeAdi
     * @param int $uyeID
     */
    public function __construct(\ArrayType\ArrayOfFormDataModel $dataList = null, $eklenmeTarihi = null, $formId = null, $iD = null, $uyeAdi = null, $uyeID = null)
    {
        $this
            ->setDataList($dataList)
            ->setEklenmeTarihi($eklenmeTarihi)
            ->setFormId($formId)
            ->setID($iD)
            ->setUyeAdi($uyeAdi)
            ->setUyeID($uyeID);
    }
    /**
     * Get DataList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfFormDataModel|null
     */
    public function getDataList()
    {
        return isset($this->DataList) ? $this->DataList : null;
    }
    /**
     * Set DataList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfFormDataModel $dataList
     * @return \StructType\DinamikFormData
     */
    public function setDataList(\ArrayType\ArrayOfFormDataModel $dataList = null)
    {
        if (is_null($dataList) || (is_array($dataList) && empty($dataList))) {
            unset($this->DataList);
        } else {
            $this->DataList = $dataList;
        }
        return $this;
    }
    /**
     * Get EklenmeTarihi value
     * @return string|null
     */
    public function getEklenmeTarihi()
    {
        return $this->EklenmeTarihi;
    }
    /**
     * Set EklenmeTarihi value
     * @param string $eklenmeTarihi
     * @return \StructType\DinamikFormData
     */
    public function setEklenmeTarihi($eklenmeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($eklenmeTarihi) && !is_string($eklenmeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eklenmeTarihi, true), gettype($eklenmeTarihi)), __LINE__);
        }
        $this->EklenmeTarihi = $eklenmeTarihi;
        return $this;
    }
    /**
     * Get FormId value
     * @return int|null
     */
    public function getFormId()
    {
        return $this->FormId;
    }
    /**
     * Set FormId value
     * @param int $formId
     * @return \StructType\DinamikFormData
     */
    public function setFormId($formId = null)
    {
        // validation for constraint: int
        if (!is_null($formId) && !(is_int($formId) || ctype_digit($formId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($formId, true), gettype($formId)), __LINE__);
        }
        $this->FormId = $formId;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\DinamikFormData
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get UyeAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUyeAdi()
    {
        return isset($this->UyeAdi) ? $this->UyeAdi : null;
    }
    /**
     * Set UyeAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uyeAdi
     * @return \StructType\DinamikFormData
     */
    public function setUyeAdi($uyeAdi = null)
    {
        // validation for constraint: string
        if (!is_null($uyeAdi) && !is_string($uyeAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uyeAdi, true), gettype($uyeAdi)), __LINE__);
        }
        if (is_null($uyeAdi) || (is_array($uyeAdi) && empty($uyeAdi))) {
            unset($this->UyeAdi);
        } else {
            $this->UyeAdi = $uyeAdi;
        }
        return $this;
    }
    /**
     * Get UyeID value
     * @return int|null
     */
    public function getUyeID()
    {
        return $this->UyeID;
    }
    /**
     * Set UyeID value
     * @param int $uyeID
     * @return \StructType\DinamikFormData
     */
    public function setUyeID($uyeID = null)
    {
        // validation for constraint: int
        if (!is_null($uyeID) && !(is_int($uyeID) || ctype_digit($uyeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uyeID, true), gettype($uyeID)), __LINE__);
        }
        $this->UyeID = $uyeID;
        return $this;
    }
}
