<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OdemeEkBilgi StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OdemeEkBilgi
 * @subpackage Structs
 */
class OdemeEkBilgi extends AbstractStructBase
{
    /**
     * The AuthCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthCode;
    /**
     * The HostRefNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HostRefNum;
    /**
     * The Issuer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Issuer;
    /**
     * The OdemeKampanyasi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OdemeKampanyasi
     */
    public $OdemeKampanyasi;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentType;
    /**
     * Constructor method for OdemeEkBilgi
     * @uses OdemeEkBilgi::setAuthCode()
     * @uses OdemeEkBilgi::setHostRefNum()
     * @uses OdemeEkBilgi::setIssuer()
     * @uses OdemeEkBilgi::setOdemeKampanyasi()
     * @uses OdemeEkBilgi::setPaymentType()
     * @param string $authCode
     * @param string $hostRefNum
     * @param string $issuer
     * @param \StructType\OdemeKampanyasi $odemeKampanyasi
     * @param string $paymentType
     */
    public function __construct($authCode = null, $hostRefNum = null, $issuer = null, \StructType\OdemeKampanyasi $odemeKampanyasi = null, $paymentType = null)
    {
        $this
            ->setAuthCode($authCode)
            ->setHostRefNum($hostRefNum)
            ->setIssuer($issuer)
            ->setOdemeKampanyasi($odemeKampanyasi)
            ->setPaymentType($paymentType);
    }
    /**
     * Get AuthCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthCode()
    {
        return isset($this->AuthCode) ? $this->AuthCode : null;
    }
    /**
     * Set AuthCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authCode
     * @return \StructType\OdemeEkBilgi
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authCode, true), gettype($authCode)), __LINE__);
        }
        if (is_null($authCode) || (is_array($authCode) && empty($authCode))) {
            unset($this->AuthCode);
        } else {
            $this->AuthCode = $authCode;
        }
        return $this;
    }
    /**
     * Get HostRefNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHostRefNum()
    {
        return isset($this->HostRefNum) ? $this->HostRefNum : null;
    }
    /**
     * Set HostRefNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hostRefNum
     * @return \StructType\OdemeEkBilgi
     */
    public function setHostRefNum($hostRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($hostRefNum) && !is_string($hostRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hostRefNum, true), gettype($hostRefNum)), __LINE__);
        }
        if (is_null($hostRefNum) || (is_array($hostRefNum) && empty($hostRefNum))) {
            unset($this->HostRefNum);
        } else {
            $this->HostRefNum = $hostRefNum;
        }
        return $this;
    }
    /**
     * Get Issuer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssuer()
    {
        return isset($this->Issuer) ? $this->Issuer : null;
    }
    /**
     * Set Issuer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issuer
     * @return \StructType\OdemeEkBilgi
     */
    public function setIssuer($issuer = null)
    {
        // validation for constraint: string
        if (!is_null($issuer) && !is_string($issuer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuer, true), gettype($issuer)), __LINE__);
        }
        if (is_null($issuer) || (is_array($issuer) && empty($issuer))) {
            unset($this->Issuer);
        } else {
            $this->Issuer = $issuer;
        }
        return $this;
    }
    /**
     * Get OdemeKampanyasi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OdemeKampanyasi|null
     */
    public function getOdemeKampanyasi()
    {
        return isset($this->OdemeKampanyasi) ? $this->OdemeKampanyasi : null;
    }
    /**
     * Set OdemeKampanyasi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OdemeKampanyasi $odemeKampanyasi
     * @return \StructType\OdemeEkBilgi
     */
    public function setOdemeKampanyasi(\StructType\OdemeKampanyasi $odemeKampanyasi = null)
    {
        if (is_null($odemeKampanyasi) || (is_array($odemeKampanyasi) && empty($odemeKampanyasi))) {
            unset($this->OdemeKampanyasi);
        } else {
            $this->OdemeKampanyasi = $odemeKampanyasi;
        }
        return $this;
    }
    /**
     * Get PaymentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentType()
    {
        return isset($this->PaymentType) ? $this->PaymentType : null;
    }
    /**
     * Set PaymentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentType
     * @return \StructType\OdemeEkBilgi
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        if (is_null($paymentType) || (is_array($paymentType) && empty($paymentType))) {
            unset($this->PaymentType);
        } else {
            $this->PaymentType = $paymentType;
        }
        return $this;
    }
}
