<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SaveSiparis
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveSiparis $parameters
     * @return \StructType\SaveSiparisResponse|bool
     */
    public function SaveSiparis(\StructType\SaveSiparis $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveSiparis($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveKargoTakipNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveKargoTakipNo $parameters
     * @return \StructType\SaveKargoTakipNoResponse|bool
     */
    public function SaveKargoTakipNo(\StructType\SaveKargoTakipNo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveKargoTakipNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveSiparisKargoPaket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveSiparisKargoPaket $parameters
     * @return \StructType\SaveSiparisKargoPaketResponse|bool
     */
    public function SaveSiparisKargoPaket(\StructType\SaveSiparisKargoPaket $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveSiparisKargoPaket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveSiparisKargoPaketKargoTakipNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveSiparisKargoPaketKargoTakipNo $parameters
     * @return \StructType\SaveSiparisKargoPaketKargoTakipNoResponse|bool
     */
    public function SaveSiparisKargoPaketKargoTakipNo(\StructType\SaveSiparisKargoPaketKargoTakipNo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveSiparisKargoPaketKargoTakipNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveMagaza
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveMagaza $parameters
     * @return \StructType\SaveMagazaResponse|bool
     */
    public function SaveMagaza(\StructType\SaveMagaza $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveMagaza($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveEFatura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveEFatura $parameters
     * @return \StructType\SaveEFaturaResponse|bool
     */
    public function SaveEFatura(\StructType\SaveEFatura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveEFatura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveBekleyenArama
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveBekleyenArama $parameters
     * @return \StructType\SaveBekleyenAramaResponse|bool
     */
    public function SaveBekleyenArama(\StructType\SaveBekleyenArama $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveBekleyenArama($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveIadeOdeme
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveIadeOdeme $parameters
     * @return \StructType\SaveIadeOdemeResponse|bool
     */
    public function SaveIadeOdeme(\StructType\SaveIadeOdeme $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveIadeOdeme($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveSiparisOdeme
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveSiparisOdeme $parameters
     * @return \StructType\SaveSiparisOdemeResponse|bool
     */
    public function SaveSiparisOdeme(\StructType\SaveSiparisOdeme $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveSiparisOdeme($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SaveBekleyenAramaResponse|\StructType\SaveEFaturaResponse|\StructType\SaveIadeOdemeResponse|\StructType\SaveKargoTakipNoResponse|\StructType\SaveMagazaResponse|\StructType\SaveSiparisKargoPaketKargoTakipNoResponse|\StructType\SaveSiparisKargoPaketResponse|\StructType\SaveSiparisOdemeResponse|\StructType\SaveSiparisResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
