<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Siparis ServiceType
 * @subpackage Services
 */
class Siparis extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SiparisKargoTakipNoKontrol
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SiparisKargoTakipNoKontrol $parameters
     * @return \StructType\SiparisKargoTakipNoKontrolResponse|bool
     */
    public function SiparisKargoTakipNoKontrol(\StructType\SiparisKargoTakipNoKontrol $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SiparisKargoTakipNoKontrol($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SiparisPaketleKargoyaGonder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SiparisPaketleKargoyaGonder $parameters
     * @return \StructType\SiparisPaketleKargoyaGonderResponse|bool
     */
    public function SiparisPaketleKargoyaGonder(\StructType\SiparisPaketleKargoyaGonder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SiparisPaketleKargoyaGonder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SiparisAnonimlestir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SiparisAnonimlestir $parameters
     * @return \StructType\SiparisAnonimlestirResponse|bool
     */
    public function SiparisAnonimlestir(\StructType\SiparisAnonimlestir $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SiparisAnonimlestir($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SiparisUrunIptalIade
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SiparisUrunIptalIade $parameters
     * @return \StructType\SiparisUrunIptalIadeResponse|bool
     */
    public function SiparisUrunIptalIade(\StructType\SiparisUrunIptalIade $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SiparisUrunIptalIade($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SiparisAnonimlestirResponse|\StructType\SiparisKargoTakipNoKontrolResponse|\StructType\SiparisPaketleKargoyaGonderResponse|\StructType\SiparisUrunIptalIadeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
