<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Odeme ServiceType
 * @subpackage Services
 */
class Odeme extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OdemeOnProvizyonKapat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OdemeOnProvizyonKapat $parameters
     * @return \StructType\OdemeOnProvizyonKapatResponse|bool
     */
    public function OdemeOnProvizyonKapat(\StructType\OdemeOnProvizyonKapat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OdemeOnProvizyonKapat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OdemeOnProvizyonKapatResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
