<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IadeOdeme StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:IadeOdeme
 * @subpackage Structs
 */
class IadeOdeme extends AbstractStructBase
{
    /**
     * The BankaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BankaId;
    /**
     * The Durum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Durum;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The IslemTip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IslemTip;
    /**
     * The KartNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KartNo;
    /**
     * The KartUzerindekiIsim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KartUzerindekiIsim;
    /**
     * The Kur
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Kur;
    /**
     * The ParaBirimi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ParaBirimi;
    /**
     * The PosRefId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PosRefId;
    /**
     * The SiparisId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisId;
    /**
     * The SiparisUrunBilgisi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebIadeOdemeSiparisUrunBilgi
     */
    public $SiparisUrunBilgisi;
    /**
     * The Tarih
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Tarih;
    /**
     * The Tutar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Tutar;
    /**
     * The UyeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UyeId;
    /**
     * Constructor method for IadeOdeme
     * @uses IadeOdeme::setBankaId()
     * @uses IadeOdeme::setDurum()
     * @uses IadeOdeme::setId()
     * @uses IadeOdeme::setIslemTip()
     * @uses IadeOdeme::setKartNo()
     * @uses IadeOdeme::setKartUzerindekiIsim()
     * @uses IadeOdeme::setKur()
     * @uses IadeOdeme::setParaBirimi()
     * @uses IadeOdeme::setPosRefId()
     * @uses IadeOdeme::setSiparisId()
     * @uses IadeOdeme::setSiparisUrunBilgisi()
     * @uses IadeOdeme::setTarih()
     * @uses IadeOdeme::setTutar()
     * @uses IadeOdeme::setUyeId()
     * @param int $bankaId
     * @param string $durum
     * @param int $id
     * @param int $islemTip
     * @param string $kartNo
     * @param string $kartUzerindekiIsim
     * @param float $kur
     * @param string $paraBirimi
     * @param string $posRefId
     * @param int $siparisId
     * @param \ArrayType\ArrayOfWebIadeOdemeSiparisUrunBilgi $siparisUrunBilgisi
     * @param string $tarih
     * @param float $tutar
     * @param int $uyeId
     */
    public function __construct($bankaId = null, $durum = null, $id = null, $islemTip = null, $kartNo = null, $kartUzerindekiIsim = null, $kur = null, $paraBirimi = null, $posRefId = null, $siparisId = null, \ArrayType\ArrayOfWebIadeOdemeSiparisUrunBilgi $siparisUrunBilgisi = null, $tarih = null, $tutar = null, $uyeId = null)
    {
        $this
            ->setBankaId($bankaId)
            ->setDurum($durum)
            ->setId($id)
            ->setIslemTip($islemTip)
            ->setKartNo($kartNo)
            ->setKartUzerindekiIsim($kartUzerindekiIsim)
            ->setKur($kur)
            ->setParaBirimi($paraBirimi)
            ->setPosRefId($posRefId)
            ->setSiparisId($siparisId)
            ->setSiparisUrunBilgisi($siparisUrunBilgisi)
            ->setTarih($tarih)
            ->setTutar($tutar)
            ->setUyeId($uyeId);
    }
    /**
     * Get BankaId value
     * @return int|null
     */
    public function getBankaId()
    {
        return $this->BankaId;
    }
    /**
     * Set BankaId value
     * @param int $bankaId
     * @return \StructType\IadeOdeme
     */
    public function setBankaId($bankaId = null)
    {
        // validation for constraint: int
        if (!is_null($bankaId) && !(is_int($bankaId) || ctype_digit($bankaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bankaId, true), gettype($bankaId)), __LINE__);
        }
        $this->BankaId = $bankaId;
        return $this;
    }
    /**
     * Get Durum value
     * @return string|null
     */
    public function getDurum()
    {
        return $this->Durum;
    }
    /**
     * Set Durum value
     * @uses \EnumType\BLEnums_OdemeDurumlari::valueIsValid()
     * @uses \EnumType\BLEnums_OdemeDurumlari::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $durum
     * @return \StructType\IadeOdeme
     */
    public function setDurum($durum = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BLEnums_OdemeDurumlari::valueIsValid($durum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BLEnums_OdemeDurumlari', is_array($durum) ? implode(', ', $durum) : var_export($durum, true), implode(', ', \EnumType\BLEnums_OdemeDurumlari::getValidValues())), __LINE__);
        }
        $this->Durum = $durum;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\IadeOdeme
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IslemTip value
     * @return int|null
     */
    public function getIslemTip()
    {
        return $this->IslemTip;
    }
    /**
     * Set IslemTip value
     * @param int $islemTip
     * @return \StructType\IadeOdeme
     */
    public function setIslemTip($islemTip = null)
    {
        // validation for constraint: int
        if (!is_null($islemTip) && !(is_int($islemTip) || ctype_digit($islemTip))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($islemTip, true), gettype($islemTip)), __LINE__);
        }
        $this->IslemTip = $islemTip;
        return $this;
    }
    /**
     * Get KartNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKartNo()
    {
        return isset($this->KartNo) ? $this->KartNo : null;
    }
    /**
     * Set KartNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kartNo
     * @return \StructType\IadeOdeme
     */
    public function setKartNo($kartNo = null)
    {
        // validation for constraint: string
        if (!is_null($kartNo) && !is_string($kartNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kartNo, true), gettype($kartNo)), __LINE__);
        }
        if (is_null($kartNo) || (is_array($kartNo) && empty($kartNo))) {
            unset($this->KartNo);
        } else {
            $this->KartNo = $kartNo;
        }
        return $this;
    }
    /**
     * Get KartUzerindekiIsim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKartUzerindekiIsim()
    {
        return isset($this->KartUzerindekiIsim) ? $this->KartUzerindekiIsim : null;
    }
    /**
     * Set KartUzerindekiIsim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kartUzerindekiIsim
     * @return \StructType\IadeOdeme
     */
    public function setKartUzerindekiIsim($kartUzerindekiIsim = null)
    {
        // validation for constraint: string
        if (!is_null($kartUzerindekiIsim) && !is_string($kartUzerindekiIsim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kartUzerindekiIsim, true), gettype($kartUzerindekiIsim)), __LINE__);
        }
        if (is_null($kartUzerindekiIsim) || (is_array($kartUzerindekiIsim) && empty($kartUzerindekiIsim))) {
            unset($this->KartUzerindekiIsim);
        } else {
            $this->KartUzerindekiIsim = $kartUzerindekiIsim;
        }
        return $this;
    }
    /**
     * Get Kur value
     * @return float|null
     */
    public function getKur()
    {
        return $this->Kur;
    }
    /**
     * Set Kur value
     * @param float $kur
     * @return \StructType\IadeOdeme
     */
    public function setKur($kur = null)
    {
        // validation for constraint: float
        if (!is_null($kur) && !(is_float($kur) || is_numeric($kur))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kur, true), gettype($kur)), __LINE__);
        }
        $this->Kur = $kur;
        return $this;
    }
    /**
     * Get ParaBirimi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParaBirimi()
    {
        return isset($this->ParaBirimi) ? $this->ParaBirimi : null;
    }
    /**
     * Set ParaBirimi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paraBirimi
     * @return \StructType\IadeOdeme
     */
    public function setParaBirimi($paraBirimi = null)
    {
        // validation for constraint: string
        if (!is_null($paraBirimi) && !is_string($paraBirimi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paraBirimi, true), gettype($paraBirimi)), __LINE__);
        }
        if (is_null($paraBirimi) || (is_array($paraBirimi) && empty($paraBirimi))) {
            unset($this->ParaBirimi);
        } else {
            $this->ParaBirimi = $paraBirimi;
        }
        return $this;
    }
    /**
     * Get PosRefId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPosRefId()
    {
        return isset($this->PosRefId) ? $this->PosRefId : null;
    }
    /**
     * Set PosRefId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $posRefId
     * @return \StructType\IadeOdeme
     */
    public function setPosRefId($posRefId = null)
    {
        // validation for constraint: string
        if (!is_null($posRefId) && !is_string($posRefId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($posRefId, true), gettype($posRefId)), __LINE__);
        }
        if (is_null($posRefId) || (is_array($posRefId) && empty($posRefId))) {
            unset($this->PosRefId);
        } else {
            $this->PosRefId = $posRefId;
        }
        return $this;
    }
    /**
     * Get SiparisId value
     * @return int|null
     */
    public function getSiparisId()
    {
        return $this->SiparisId;
    }
    /**
     * Set SiparisId value
     * @param int $siparisId
     * @return \StructType\IadeOdeme
     */
    public function setSiparisId($siparisId = null)
    {
        // validation for constraint: int
        if (!is_null($siparisId) && !(is_int($siparisId) || ctype_digit($siparisId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisId, true), gettype($siparisId)), __LINE__);
        }
        $this->SiparisId = $siparisId;
        return $this;
    }
    /**
     * Get SiparisUrunBilgisi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebIadeOdemeSiparisUrunBilgi|null
     */
    public function getSiparisUrunBilgisi()
    {
        return isset($this->SiparisUrunBilgisi) ? $this->SiparisUrunBilgisi : null;
    }
    /**
     * Set SiparisUrunBilgisi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebIadeOdemeSiparisUrunBilgi $siparisUrunBilgisi
     * @return \StructType\IadeOdeme
     */
    public function setSiparisUrunBilgisi(\ArrayType\ArrayOfWebIadeOdemeSiparisUrunBilgi $siparisUrunBilgisi = null)
    {
        if (is_null($siparisUrunBilgisi) || (is_array($siparisUrunBilgisi) && empty($siparisUrunBilgisi))) {
            unset($this->SiparisUrunBilgisi);
        } else {
            $this->SiparisUrunBilgisi = $siparisUrunBilgisi;
        }
        return $this;
    }
    /**
     * Get Tarih value
     * @return string|null
     */
    public function getTarih()
    {
        return $this->Tarih;
    }
    /**
     * Set Tarih value
     * @param string $tarih
     * @return \StructType\IadeOdeme
     */
    public function setTarih($tarih = null)
    {
        // validation for constraint: string
        if (!is_null($tarih) && !is_string($tarih)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tarih, true), gettype($tarih)), __LINE__);
        }
        $this->Tarih = $tarih;
        return $this;
    }
    /**
     * Get Tutar value
     * @return float|null
     */
    public function getTutar()
    {
        return $this->Tutar;
    }
    /**
     * Set Tutar value
     * @param float $tutar
     * @return \StructType\IadeOdeme
     */
    public function setTutar($tutar = null)
    {
        // validation for constraint: float
        if (!is_null($tutar) && !(is_float($tutar) || is_numeric($tutar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tutar, true), gettype($tutar)), __LINE__);
        }
        $this->Tutar = $tutar;
        return $this;
    }
    /**
     * Get UyeId value
     * @return int|null
     */
    public function getUyeId()
    {
        return $this->UyeId;
    }
    /**
     * Set UyeId value
     * @param int $uyeId
     * @return \StructType\IadeOdeme
     */
    public function setUyeId($uyeId = null)
    {
        // validation for constraint: int
        if (!is_null($uyeId) && !(is_int($uyeId) || ctype_digit($uyeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uyeId, true), gettype($uyeId)), __LINE__);
        }
        $this->UyeId = $uyeId;
        return $this;
    }
}
