<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTraceByVoucherResponse SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexGetTraceByVoucherResponse extends AbstractStructBase
{
    /**
     * The returnCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $returnCode;
    /**
     * The checkpoints
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Speedex\SpeedexArray\SpeedexArrayOfCheckpoint
     */
    public $checkpoints;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for GetTraceByVoucherResponse
     * @uses SpeedexGetTraceByVoucherResponse::setReturnCode()
     * @uses SpeedexGetTraceByVoucherResponse::setCheckpoints()
     * @uses SpeedexGetTraceByVoucherResponse::setReturnMessage()
     * @param int $returnCode
     * @param \Speedex\SpeedexArray\SpeedexArrayOfCheckpoint $checkpoints
     * @param string $returnMessage
     */
    public function __construct($returnCode = null, \Speedex\SpeedexArray\SpeedexArrayOfCheckpoint $checkpoints = null, $returnMessage = null)
    {
        $this
            ->setReturnCode($returnCode)
            ->setCheckpoints($checkpoints)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get returnCode value
     * @return int
     */
    public function getReturnCode()
    {
        return $this->returnCode;
    }
    /**
     * Set returnCode value
     * @param int $returnCode
     * @return \Speedex\SpeedexStruct\SpeedexGetTraceByVoucherResponse
     */
    public function setReturnCode($returnCode = null)
    {
        // validation for constraint: int
        if (!is_null($returnCode) && !(is_int($returnCode) || ctype_digit($returnCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($returnCode, true), gettype($returnCode)), __LINE__);
        }
        $this->returnCode = $returnCode;
        return $this;
    }
    /**
     * Get checkpoints value
     * @return \Speedex\SpeedexArray\SpeedexArrayOfCheckpoint|null
     */
    public function getCheckpoints()
    {
        return $this->checkpoints;
    }
    /**
     * Set checkpoints value
     * @param \Speedex\SpeedexArray\SpeedexArrayOfCheckpoint $checkpoints
     * @return \Speedex\SpeedexStruct\SpeedexGetTraceByVoucherResponse
     */
    public function setCheckpoints(\Speedex\SpeedexArray\SpeedexArrayOfCheckpoint $checkpoints = null)
    {
        $this->checkpoints = $checkpoints;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \Speedex\SpeedexStruct\SpeedexGetTraceByVoucherResponse
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
