<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPickup SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexGetPickup extends AbstractStructBase
{
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sessionID;
    /**
     * The pickupNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pickupNumber;
    /**
     * Constructor method for GetPickup
     * @uses SpeedexGetPickup::setSessionID()
     * @uses SpeedexGetPickup::setPickupNumber()
     * @param string $sessionID
     * @param string $pickupNumber
     */
    public function __construct($sessionID = null, $pickupNumber = null)
    {
        $this
            ->setSessionID($sessionID)
            ->setPickupNumber($pickupNumber);
    }
    /**
     * Get sessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->sessionID;
    }
    /**
     * Set sessionID value
     * @param string $sessionID
     * @return \Speedex\SpeedexStruct\SpeedexGetPickup
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionID, true), gettype($sessionID)), __LINE__);
        }
        $this->sessionID = $sessionID;
        return $this;
    }
    /**
     * Get pickupNumber value
     * @return string|null
     */
    public function getPickupNumber()
    {
        return $this->pickupNumber;
    }
    /**
     * Set pickupNumber value
     * @param string $pickupNumber
     * @return \Speedex\SpeedexStruct\SpeedexGetPickup
     */
    public function setPickupNumber($pickupNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pickupNumber) && !is_string($pickupNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupNumber, true), gettype($pickupNumber)), __LINE__);
        }
        $this->pickupNumber = $pickupNumber;
        return $this;
    }
}
