<?php

namespace Speedex\SpeedexService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel SpeedexService
 * @package Speedex
 * @subpackage Services
 */
class SpeedexCancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelBOL
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexCancelBOL $parameters
     * @return \Speedex\SpeedexStruct\SpeedexCancelBOLResponse|bool
     */
    public function CancelBOL(\Speedex\SpeedexStruct\SpeedexCancelBOL $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelBOL($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelBOLandOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexCancelBOLandOrder $parameters
     * @return \Speedex\SpeedexStruct\SpeedexCancelBOLandOrderResponse|bool
     */
    public function CancelBOLandOrder(\Speedex\SpeedexStruct\SpeedexCancelBOLandOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelBOLandOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelPickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexCancelPickup $parameters
     * @return \Speedex\SpeedexStruct\SpeedexCancelPickupResponse|bool
     */
    public function CancelPickup(\Speedex\SpeedexStruct\SpeedexCancelPickup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelPickup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Speedex\SpeedexStruct\SpeedexCancelBOLandOrderResponse|\Speedex\SpeedexStruct\SpeedexCancelBOLResponse|\Speedex\SpeedexStruct\SpeedexCancelPickupResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
