<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupOrder SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexPickupOrder extends AbstractStructBase
{
    /**
     * The PU_Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PU_Date;
    /**
     * The PU_Time_From
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PU_Time_From;
    /**
     * The Saturday_PU
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Saturday_PU;
    /**
     * The Time_Frame
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Time_Frame;
    /**
     * The No_Of_Folders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $No_Of_Folders;
    /**
     * The No_Of_Parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $No_Of_Parcels;
    /**
     * The Beneficiary_Agreement_Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Beneficiary_Agreement_Code;
    /**
     * The Delivery_Customer_Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Delivery_Customer_Comments;
    /**
     * The PU_Depot_Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PU_Depot_Code;
    /**
     * The PU_Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PU_Address;
    /**
     * The PU_City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PU_City;
    /**
     * The PU_Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PU_Name;
    /**
     * The PU_Phone_No
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PU_Phone_No;
    /**
     * The PU_Post_Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PU_Post_Code;
    /**
     * The PU_Floor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PU_Floor;
    /**
     * The PU_Doorbell
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PU_Doorbell;
    /**
     * The PU_Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PU_Email;
    /**
     * The PU_Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PU_Comments;
    /**
     * The PU_Customer_Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PU_Customer_Comments;
    /**
     * The Consignments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Speedex\SpeedexArray\SpeedexArrayOfString
     */
    public $Consignments;
    /**
     * Constructor method for PickupOrder
     * @uses SpeedexPickupOrder::setPU_Date()
     * @uses SpeedexPickupOrder::setPU_Time_From()
     * @uses SpeedexPickupOrder::setSaturday_PU()
     * @uses SpeedexPickupOrder::setTime_Frame()
     * @uses SpeedexPickupOrder::setNo_Of_Folders()
     * @uses SpeedexPickupOrder::setNo_Of_Parcels()
     * @uses SpeedexPickupOrder::setBeneficiary_Agreement_Code()
     * @uses SpeedexPickupOrder::setDelivery_Customer_Comments()
     * @uses SpeedexPickupOrder::setPU_Depot_Code()
     * @uses SpeedexPickupOrder::setPU_Address()
     * @uses SpeedexPickupOrder::setPU_City()
     * @uses SpeedexPickupOrder::setPU_Name()
     * @uses SpeedexPickupOrder::setPU_Phone_No()
     * @uses SpeedexPickupOrder::setPU_Post_Code()
     * @uses SpeedexPickupOrder::setPU_Floor()
     * @uses SpeedexPickupOrder::setPU_Doorbell()
     * @uses SpeedexPickupOrder::setPU_Email()
     * @uses SpeedexPickupOrder::setPU_Comments()
     * @uses SpeedexPickupOrder::setPU_Customer_Comments()
     * @uses SpeedexPickupOrder::setConsignments()
     * @param string $pU_Date
     * @param string $pU_Time_From
     * @param bool $saturday_PU
     * @param bool $time_Frame
     * @param int $no_Of_Folders
     * @param int $no_Of_Parcels
     * @param string $beneficiary_Agreement_Code
     * @param string $delivery_Customer_Comments
     * @param string $pU_Depot_Code
     * @param string $pU_Address
     * @param string $pU_City
     * @param string $pU_Name
     * @param string $pU_Phone_No
     * @param string $pU_Post_Code
     * @param string $pU_Floor
     * @param string $pU_Doorbell
     * @param string $pU_Email
     * @param string $pU_Comments
     * @param string $pU_Customer_Comments
     * @param \Speedex\SpeedexArray\SpeedexArrayOfString $consignments
     */
    public function __construct($pU_Date = null, $pU_Time_From = null, $saturday_PU = null, $time_Frame = null, $no_Of_Folders = null, $no_Of_Parcels = null, $beneficiary_Agreement_Code = null, $delivery_Customer_Comments = null, $pU_Depot_Code = null, $pU_Address = null, $pU_City = null, $pU_Name = null, $pU_Phone_No = null, $pU_Post_Code = null, $pU_Floor = null, $pU_Doorbell = null, $pU_Email = null, $pU_Comments = null, $pU_Customer_Comments = null, \Speedex\SpeedexArray\SpeedexArrayOfString $consignments = null)
    {
        $this
            ->setPU_Date($pU_Date)
            ->setPU_Time_From($pU_Time_From)
            ->setSaturday_PU($saturday_PU)
            ->setTime_Frame($time_Frame)
            ->setNo_Of_Folders($no_Of_Folders)
            ->setNo_Of_Parcels($no_Of_Parcels)
            ->setBeneficiary_Agreement_Code($beneficiary_Agreement_Code)
            ->setDelivery_Customer_Comments($delivery_Customer_Comments)
            ->setPU_Depot_Code($pU_Depot_Code)
            ->setPU_Address($pU_Address)
            ->setPU_City($pU_City)
            ->setPU_Name($pU_Name)
            ->setPU_Phone_No($pU_Phone_No)
            ->setPU_Post_Code($pU_Post_Code)
            ->setPU_Floor($pU_Floor)
            ->setPU_Doorbell($pU_Doorbell)
            ->setPU_Email($pU_Email)
            ->setPU_Comments($pU_Comments)
            ->setPU_Customer_Comments($pU_Customer_Comments)
            ->setConsignments($consignments);
    }
    /**
     * Get PU_Date value
     * @return string
     */
    public function getPU_Date()
    {
        return $this->PU_Date;
    }
    /**
     * Set PU_Date value
     * @param string $pU_Date
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setPU_Date($pU_Date = null)
    {
        // validation for constraint: string
        if (!is_null($pU_Date) && !is_string($pU_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pU_Date, true), gettype($pU_Date)), __LINE__);
        }
        $this->PU_Date = $pU_Date;
        return $this;
    }
    /**
     * Get PU_Time_From value
     * @return string
     */
    public function getPU_Time_From()
    {
        return $this->PU_Time_From;
    }
    /**
     * Set PU_Time_From value
     * @param string $pU_Time_From
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setPU_Time_From($pU_Time_From = null)
    {
        // validation for constraint: string
        if (!is_null($pU_Time_From) && !is_string($pU_Time_From)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pU_Time_From, true), gettype($pU_Time_From)), __LINE__);
        }
        $this->PU_Time_From = $pU_Time_From;
        return $this;
    }
    /**
     * Get Saturday_PU value
     * @return bool
     */
    public function getSaturday_PU()
    {
        return $this->Saturday_PU;
    }
    /**
     * Set Saturday_PU value
     * @param bool $saturday_PU
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setSaturday_PU($saturday_PU = null)
    {
        // validation for constraint: boolean
        if (!is_null($saturday_PU) && !is_bool($saturday_PU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($saturday_PU, true), gettype($saturday_PU)), __LINE__);
        }
        $this->Saturday_PU = $saturday_PU;
        return $this;
    }
    /**
     * Get Time_Frame value
     * @return bool
     */
    public function getTime_Frame()
    {
        return $this->Time_Frame;
    }
    /**
     * Set Time_Frame value
     * @param bool $time_Frame
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setTime_Frame($time_Frame = null)
    {
        // validation for constraint: boolean
        if (!is_null($time_Frame) && !is_bool($time_Frame)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($time_Frame, true), gettype($time_Frame)), __LINE__);
        }
        $this->Time_Frame = $time_Frame;
        return $this;
    }
    /**
     * Get No_Of_Folders value
     * @return int
     */
    public function getNo_Of_Folders()
    {
        return $this->No_Of_Folders;
    }
    /**
     * Set No_Of_Folders value
     * @param int $no_Of_Folders
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setNo_Of_Folders($no_Of_Folders = null)
    {
        // validation for constraint: int
        if (!is_null($no_Of_Folders) && !(is_int($no_Of_Folders) || ctype_digit($no_Of_Folders))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($no_Of_Folders, true), gettype($no_Of_Folders)), __LINE__);
        }
        $this->No_Of_Folders = $no_Of_Folders;
        return $this;
    }
    /**
     * Get No_Of_Parcels value
     * @return int
     */
    public function getNo_Of_Parcels()
    {
        return $this->No_Of_Parcels;
    }
    /**
     * Set No_Of_Parcels value
     * @param int $no_Of_Parcels
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setNo_Of_Parcels($no_Of_Parcels = null)
    {
        // validation for constraint: int
        if (!is_null($no_Of_Parcels) && !(is_int($no_Of_Parcels) || ctype_digit($no_Of_Parcels))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($no_Of_Parcels, true), gettype($no_Of_Parcels)), __LINE__);
        }
        $this->No_Of_Parcels = $no_Of_Parcels;
        return $this;
    }
    /**
     * Get Beneficiary_Agreement_Code value
     * @return string|null
     */
    public function getBeneficiary_Agreement_Code()
    {
        return $this->Beneficiary_Agreement_Code;
    }
    /**
     * Set Beneficiary_Agreement_Code value
     * @param string $beneficiary_Agreement_Code
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setBeneficiary_Agreement_Code($beneficiary_Agreement_Code = null)
    {
        // validation for constraint: string
        if (!is_null($beneficiary_Agreement_Code) && !is_string($beneficiary_Agreement_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beneficiary_Agreement_Code, true), gettype($beneficiary_Agreement_Code)), __LINE__);
        }
        $this->Beneficiary_Agreement_Code = $beneficiary_Agreement_Code;
        return $this;
    }
    /**
     * Get Delivery_Customer_Comments value
     * @return string|null
     */
    public function getDelivery_Customer_Comments()
    {
        return $this->Delivery_Customer_Comments;
    }
    /**
     * Set Delivery_Customer_Comments value
     * @param string $delivery_Customer_Comments
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setDelivery_Customer_Comments($delivery_Customer_Comments = null)
    {
        // validation for constraint: string
        if (!is_null($delivery_Customer_Comments) && !is_string($delivery_Customer_Comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delivery_Customer_Comments, true), gettype($delivery_Customer_Comments)), __LINE__);
        }
        $this->Delivery_Customer_Comments = $delivery_Customer_Comments;
        return $this;
    }
    /**
     * Get PU_Depot_Code value
     * @return string|null
     */
    public function getPU_Depot_Code()
    {
        return $this->PU_Depot_Code;
    }
    /**
     * Set PU_Depot_Code value
     * @param string $pU_Depot_Code
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setPU_Depot_Code($pU_Depot_Code = null)
    {
        // validation for constraint: string
        if (!is_null($pU_Depot_Code) && !is_string($pU_Depot_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pU_Depot_Code, true), gettype($pU_Depot_Code)), __LINE__);
        }
        $this->PU_Depot_Code = $pU_Depot_Code;
        return $this;
    }
    /**
     * Get PU_Address value
     * @return string|null
     */
    public function getPU_Address()
    {
        return $this->PU_Address;
    }
    /**
     * Set PU_Address value
     * @param string $pU_Address
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setPU_Address($pU_Address = null)
    {
        // validation for constraint: string
        if (!is_null($pU_Address) && !is_string($pU_Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pU_Address, true), gettype($pU_Address)), __LINE__);
        }
        $this->PU_Address = $pU_Address;
        return $this;
    }
    /**
     * Get PU_City value
     * @return string|null
     */
    public function getPU_City()
    {
        return $this->PU_City;
    }
    /**
     * Set PU_City value
     * @param string $pU_City
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setPU_City($pU_City = null)
    {
        // validation for constraint: string
        if (!is_null($pU_City) && !is_string($pU_City)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pU_City, true), gettype($pU_City)), __LINE__);
        }
        $this->PU_City = $pU_City;
        return $this;
    }
    /**
     * Get PU_Name value
     * @return string|null
     */
    public function getPU_Name()
    {
        return $this->PU_Name;
    }
    /**
     * Set PU_Name value
     * @param string $pU_Name
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setPU_Name($pU_Name = null)
    {
        // validation for constraint: string
        if (!is_null($pU_Name) && !is_string($pU_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pU_Name, true), gettype($pU_Name)), __LINE__);
        }
        $this->PU_Name = $pU_Name;
        return $this;
    }
    /**
     * Get PU_Phone_No value
     * @return string|null
     */
    public function getPU_Phone_No()
    {
        return $this->PU_Phone_No;
    }
    /**
     * Set PU_Phone_No value
     * @param string $pU_Phone_No
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setPU_Phone_No($pU_Phone_No = null)
    {
        // validation for constraint: string
        if (!is_null($pU_Phone_No) && !is_string($pU_Phone_No)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pU_Phone_No, true), gettype($pU_Phone_No)), __LINE__);
        }
        $this->PU_Phone_No = $pU_Phone_No;
        return $this;
    }
    /**
     * Get PU_Post_Code value
     * @return string|null
     */
    public function getPU_Post_Code()
    {
        return $this->PU_Post_Code;
    }
    /**
     * Set PU_Post_Code value
     * @param string $pU_Post_Code
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setPU_Post_Code($pU_Post_Code = null)
    {
        // validation for constraint: string
        if (!is_null($pU_Post_Code) && !is_string($pU_Post_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pU_Post_Code, true), gettype($pU_Post_Code)), __LINE__);
        }
        $this->PU_Post_Code = $pU_Post_Code;
        return $this;
    }
    /**
     * Get PU_Floor value
     * @return string|null
     */
    public function getPU_Floor()
    {
        return $this->PU_Floor;
    }
    /**
     * Set PU_Floor value
     * @param string $pU_Floor
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setPU_Floor($pU_Floor = null)
    {
        // validation for constraint: string
        if (!is_null($pU_Floor) && !is_string($pU_Floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pU_Floor, true), gettype($pU_Floor)), __LINE__);
        }
        $this->PU_Floor = $pU_Floor;
        return $this;
    }
    /**
     * Get PU_Doorbell value
     * @return string|null
     */
    public function getPU_Doorbell()
    {
        return $this->PU_Doorbell;
    }
    /**
     * Set PU_Doorbell value
     * @param string $pU_Doorbell
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setPU_Doorbell($pU_Doorbell = null)
    {
        // validation for constraint: string
        if (!is_null($pU_Doorbell) && !is_string($pU_Doorbell)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pU_Doorbell, true), gettype($pU_Doorbell)), __LINE__);
        }
        $this->PU_Doorbell = $pU_Doorbell;
        return $this;
    }
    /**
     * Get PU_Email value
     * @return string|null
     */
    public function getPU_Email()
    {
        return $this->PU_Email;
    }
    /**
     * Set PU_Email value
     * @param string $pU_Email
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setPU_Email($pU_Email = null)
    {
        // validation for constraint: string
        if (!is_null($pU_Email) && !is_string($pU_Email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pU_Email, true), gettype($pU_Email)), __LINE__);
        }
        $this->PU_Email = $pU_Email;
        return $this;
    }
    /**
     * Get PU_Comments value
     * @return string|null
     */
    public function getPU_Comments()
    {
        return $this->PU_Comments;
    }
    /**
     * Set PU_Comments value
     * @param string $pU_Comments
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setPU_Comments($pU_Comments = null)
    {
        // validation for constraint: string
        if (!is_null($pU_Comments) && !is_string($pU_Comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pU_Comments, true), gettype($pU_Comments)), __LINE__);
        }
        $this->PU_Comments = $pU_Comments;
        return $this;
    }
    /**
     * Get PU_Customer_Comments value
     * @return string|null
     */
    public function getPU_Customer_Comments()
    {
        return $this->PU_Customer_Comments;
    }
    /**
     * Set PU_Customer_Comments value
     * @param string $pU_Customer_Comments
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setPU_Customer_Comments($pU_Customer_Comments = null)
    {
        // validation for constraint: string
        if (!is_null($pU_Customer_Comments) && !is_string($pU_Customer_Comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pU_Customer_Comments, true), gettype($pU_Customer_Comments)), __LINE__);
        }
        $this->PU_Customer_Comments = $pU_Customer_Comments;
        return $this;
    }
    /**
     * Get Consignments value
     * @return \Speedex\SpeedexArray\SpeedexArrayOfString|null
     */
    public function getConsignments()
    {
        return $this->Consignments;
    }
    /**
     * Set Consignments value
     * @param \Speedex\SpeedexArray\SpeedexArrayOfString $consignments
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public function setConsignments(\Speedex\SpeedexArray\SpeedexArrayOfString $consignments = null)
    {
        $this->Consignments = $consignments;
        return $this;
    }
}
