<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTraceByPickupResponse SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexGetTraceByPickupResponse extends AbstractStructBase
{
    /**
     * The returnCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $returnCode;
    /**
     * The result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Speedex\SpeedexStruct\SpeedexPickupCheckpointConsignments
     */
    public $result;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for GetTraceByPickupResponse
     * @uses SpeedexGetTraceByPickupResponse::setReturnCode()
     * @uses SpeedexGetTraceByPickupResponse::setResult()
     * @uses SpeedexGetTraceByPickupResponse::setReturnMessage()
     * @param int $returnCode
     * @param \Speedex\SpeedexStruct\SpeedexPickupCheckpointConsignments $result
     * @param string $returnMessage
     */
    public function __construct($returnCode = null, \Speedex\SpeedexStruct\SpeedexPickupCheckpointConsignments $result = null, $returnMessage = null)
    {
        $this
            ->setReturnCode($returnCode)
            ->setResult($result)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get returnCode value
     * @return int
     */
    public function getReturnCode()
    {
        return $this->returnCode;
    }
    /**
     * Set returnCode value
     * @param int $returnCode
     * @return \Speedex\SpeedexStruct\SpeedexGetTraceByPickupResponse
     */
    public function setReturnCode($returnCode = null)
    {
        // validation for constraint: int
        if (!is_null($returnCode) && !(is_int($returnCode) || ctype_digit($returnCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($returnCode, true), gettype($returnCode)), __LINE__);
        }
        $this->returnCode = $returnCode;
        return $this;
    }
    /**
     * Get result value
     * @return \Speedex\SpeedexStruct\SpeedexPickupCheckpointConsignments|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param \Speedex\SpeedexStruct\SpeedexPickupCheckpointConsignments $result
     * @return \Speedex\SpeedexStruct\SpeedexGetTraceByPickupResponse
     */
    public function setResult(\Speedex\SpeedexStruct\SpeedexPickupCheckpointConsignments $result = null)
    {
        $this->result = $result;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \Speedex\SpeedexStruct\SpeedexGetTraceByPickupResponse
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
