<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTraceByPickup SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexGetTraceByPickup extends AbstractStructBase
{
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sessionID;
    /**
     * The PickupId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PickupId;
    /**
     * Constructor method for GetTraceByPickup
     * @uses SpeedexGetTraceByPickup::setSessionID()
     * @uses SpeedexGetTraceByPickup::setPickupId()
     * @param string $sessionID
     * @param string $pickupId
     */
    public function __construct($sessionID = null, $pickupId = null)
    {
        $this
            ->setSessionID($sessionID)
            ->setPickupId($pickupId);
    }
    /**
     * Get sessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->sessionID;
    }
    /**
     * Set sessionID value
     * @param string $sessionID
     * @return \Speedex\SpeedexStruct\SpeedexGetTraceByPickup
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionID, true), gettype($sessionID)), __LINE__);
        }
        $this->sessionID = $sessionID;
        return $this;
    }
    /**
     * Get PickupId value
     * @return string|null
     */
    public function getPickupId()
    {
        return $this->PickupId;
    }
    /**
     * Set PickupId value
     * @param string $pickupId
     * @return \Speedex\SpeedexStruct\SpeedexGetTraceByPickup
     */
    public function setPickupId($pickupId = null)
    {
        // validation for constraint: string
        if (!is_null($pickupId) && !is_string($pickupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupId, true), gettype($pickupId)), __LINE__);
        }
        $this->PickupId = $pickupId;
        return $this;
    }
}
