<?php

namespace Speedex\SpeedexService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get SpeedexService
 * @package Speedex
 * @subpackage Services
 */
class SpeedexGet extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetBOLPdf
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexGetBOLPdf $parameters
     * @return \Speedex\SpeedexStruct\SpeedexGetBOLPdfResponse|bool
     */
    public function GetBOLPdf(\Speedex\SpeedexStruct\SpeedexGetBOLPdf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBOLPdf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBOLSummaryPdf
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexGetBOLSummaryPdf $parameters
     * @return \Speedex\SpeedexStruct\SpeedexGetBOLSummaryPdfResponse|bool
     */
    public function GetBOLSummaryPdf(\Speedex\SpeedexStruct\SpeedexGetBOLSummaryPdf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBOLSummaryPdf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBranches
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexGetBranches $parameters
     * @return \Speedex\SpeedexStruct\SpeedexGetBranchesResponse|bool
     */
    public function GetBranches(\Speedex\SpeedexStruct\SpeedexGetBranches $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBranches($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLastCheckpoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexGetLastCheckpoint $parameters
     * @return \Speedex\SpeedexStruct\SpeedexGetLastCheckpointResponse|bool
     */
    public function GetLastCheckpoint(\Speedex\SpeedexStruct\SpeedexGetLastCheckpoint $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLastCheckpoint($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderLastCheckpoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexGetOrderLastCheckpoint $parameters
     * @return \Speedex\SpeedexStruct\SpeedexGetOrderLastCheckpointResponse|bool
     */
    public function GetOrderLastCheckpoint(\Speedex\SpeedexStruct\SpeedexGetOrderLastCheckpoint $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderLastCheckpoint($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTraceByClientKey
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexGetTraceByClientKey $parameters
     * @return \Speedex\SpeedexStruct\SpeedexGetTraceByClientKeyResponse|bool
     */
    public function GetTraceByClientKey(\Speedex\SpeedexStruct\SpeedexGetTraceByClientKey $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTraceByClientKey($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTraceByDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexGetTraceByDate $parameters
     * @return \Speedex\SpeedexStruct\SpeedexGetTraceByDateResponse|bool
     */
    public function GetTraceByDate(\Speedex\SpeedexStruct\SpeedexGetTraceByDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTraceByDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTraceByVoucher
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexGetTraceByVoucher $parameters
     * @return \Speedex\SpeedexStruct\SpeedexGetTraceByVoucherResponse|bool
     */
    public function GetTraceByVoucher(\Speedex\SpeedexStruct\SpeedexGetTraceByVoucher $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTraceByVoucher($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTraceByPickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexGetTraceByPickup $parameters
     * @return \Speedex\SpeedexStruct\SpeedexGetTraceByPickupResponse|bool
     */
    public function GetTraceByPickup(\Speedex\SpeedexStruct\SpeedexGetTraceByPickup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTraceByPickup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCODByVoucher
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexGetCODByVoucher $parameters
     * @return \Speedex\SpeedexStruct\SpeedexGetCODByVoucherResponse|bool
     */
    public function GetCODByVoucher(\Speedex\SpeedexStruct\SpeedexGetCODByVoucher $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCODByVoucher($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherFromCustomerKey
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexGetVoucherFromCustomerKey $parameters
     * @return \Speedex\SpeedexStruct\SpeedexGetVoucherFromCustomerKeyResponse|bool
     */
    public function GetVoucherFromCustomerKey(\Speedex\SpeedexStruct\SpeedexGetVoucherFromCustomerKey $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVoucherFromCustomerKey($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherPOD
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexGetVoucherPOD $parameters
     * @return \Speedex\SpeedexStruct\SpeedexGetVoucherPODResponse|bool
     */
    public function GetVoucherPOD(\Speedex\SpeedexStruct\SpeedexGetVoucherPOD $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVoucherPOD($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetConsignmentsByDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexGetConsignmentsByDate $parameters
     * @return \Speedex\SpeedexStruct\SpeedexGetConsignmentsByDateResponse|bool
     */
    public function GetConsignmentsByDate(\Speedex\SpeedexStruct\SpeedexGetConsignmentsByDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetConsignmentsByDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDepositedConsignmentsByDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexGetDepositedConsignmentsByDate $parameters
     * @return \Speedex\SpeedexStruct\SpeedexGetDepositedConsignmentsByDateResponse|bool
     */
    public function GetDepositedConsignmentsByDate(\Speedex\SpeedexStruct\SpeedexGetDepositedConsignmentsByDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDepositedConsignmentsByDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexGetPickup $parameters
     * @return \Speedex\SpeedexStruct\SpeedexGetPickupResponse|bool
     */
    public function GetPickup(\Speedex\SpeedexStruct\SpeedexGetPickup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPickup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTraceByVoucherCOSMOTE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexGetTraceByVoucherCOSMOTE $parameters
     * @return \Speedex\SpeedexStruct\SpeedexGetTraceByVoucherCOSMOTEResponse|bool
     */
    public function GetTraceByVoucherCOSMOTE(\Speedex\SpeedexStruct\SpeedexGetTraceByVoucherCOSMOTE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTraceByVoucherCOSMOTE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Speedex\SpeedexStruct\SpeedexGetBOLPdfResponse|\Speedex\SpeedexStruct\SpeedexGetBOLSummaryPdfResponse|\Speedex\SpeedexStruct\SpeedexGetBranchesResponse|\Speedex\SpeedexStruct\SpeedexGetCODByVoucherResponse|\Speedex\SpeedexStruct\SpeedexGetConsignmentsByDateResponse|\Speedex\SpeedexStruct\SpeedexGetDepositedConsignmentsByDateResponse|\Speedex\SpeedexStruct\SpeedexGetLastCheckpointResponse|\Speedex\SpeedexStruct\SpeedexGetOrderLastCheckpointResponse|\Speedex\SpeedexStruct\SpeedexGetPickupResponse|\Speedex\SpeedexStruct\SpeedexGetTraceByClientKeyResponse|\Speedex\SpeedexStruct\SpeedexGetTraceByDateResponse|\Speedex\SpeedexStruct\SpeedexGetTraceByPickupResponse|\Speedex\SpeedexStruct\SpeedexGetTraceByVoucherCOSMOTEResponse|\Speedex\SpeedexStruct\SpeedexGetTraceByVoucherResponse|\Speedex\SpeedexStruct\SpeedexGetVoucherFromCustomerKeyResponse|\Speedex\SpeedexStruct\SpeedexGetVoucherPODResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
