<?php

namespace Speedex\SpeedexArray;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfConsignment SpeedexArray
 * @package Speedex
 * @subpackage Arrays
 */
class SpeedexArrayOfConsignment extends AbstractStructArrayBase
{
    /**
     * The Consignment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Speedex\SpeedexStruct\SpeedexConsignment[]
     */
    public $Consignment;
    /**
     * Constructor method for ArrayOfConsignment
     * @uses SpeedexArrayOfConsignment::setConsignment()
     * @param \Speedex\SpeedexStruct\SpeedexConsignment[] $consignment
     */
    public function __construct(array $consignment = array())
    {
        $this
            ->setConsignment($consignment);
    }
    /**
     * Get Consignment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Speedex\SpeedexStruct\SpeedexConsignment[]|null
     */
    public function getConsignment()
    {
        return isset($this->Consignment) ? $this->Consignment : null;
    }
    /**
     * This method is responsible for validating the values passed to the setConsignment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConsignment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConsignmentForArrayConstraintsFromSetConsignment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfConsignmentConsignmentItem) {
            // validation for constraint: itemType
            if (!$arrayOfConsignmentConsignmentItem instanceof \Speedex\SpeedexStruct\SpeedexConsignment) {
                $invalidValues[] = is_object($arrayOfConsignmentConsignmentItem) ? get_class($arrayOfConsignmentConsignmentItem) : sprintf('%s(%s)', gettype($arrayOfConsignmentConsignmentItem), var_export($arrayOfConsignmentConsignmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Consignment property can only contain items of type \Speedex\SpeedexStruct\SpeedexConsignment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Consignment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Speedex\SpeedexStruct\SpeedexConsignment[] $consignment
     * @return \Speedex\SpeedexArray\SpeedexArrayOfConsignment
     */
    public function setConsignment(array $consignment = array())
    {
        // validation for constraint: array
        if ('' !== ($consignmentArrayErrorMessage = self::validateConsignmentForArrayConstraintsFromSetConsignment($consignment))) {
            throw new \InvalidArgumentException($consignmentArrayErrorMessage, __LINE__);
        }
        if (is_null($consignment) || (is_array($consignment) && empty($consignment))) {
            unset($this->Consignment);
        } else {
            $this->Consignment = $consignment;
        }
        return $this;
    }
    /**
     * Add item to Consignment value
     * @throws \InvalidArgumentException
     * @param \Speedex\SpeedexStruct\SpeedexConsignment $item
     * @return \Speedex\SpeedexArray\SpeedexArrayOfConsignment
     */
    public function addToConsignment(\Speedex\SpeedexStruct\SpeedexConsignment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Speedex\SpeedexStruct\SpeedexConsignment) {
            throw new \InvalidArgumentException(sprintf('The Consignment property can only contain items of type \Speedex\SpeedexStruct\SpeedexConsignment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Consignment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Speedex\SpeedexStruct\SpeedexConsignment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Speedex\SpeedexStruct\SpeedexConsignment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Speedex\SpeedexStruct\SpeedexConsignment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Speedex\SpeedexStruct\SpeedexConsignment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Speedex\SpeedexStruct\SpeedexConsignment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Consignment
     */
    public function getAttributeName()
    {
        return 'Consignment';
    }
}
