<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Voucher SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexVoucher extends AbstractStructBase
{
    /**
     * The pdf
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pdf;
    /**
     * The VoucherID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VoucherID;
    /**
     * Constructor method for Voucher
     * @uses SpeedexVoucher::setPdf()
     * @uses SpeedexVoucher::setVoucherID()
     * @param string $pdf
     * @param string $voucherID
     */
    public function __construct($pdf = null, $voucherID = null)
    {
        $this
            ->setPdf($pdf)
            ->setVoucherID($voucherID);
    }
    /**
     * Get pdf value
     * @return string|null
     */
    public function getPdf()
    {
        return $this->pdf;
    }
    /**
     * Set pdf value
     * @param string $pdf
     * @return \Speedex\SpeedexStruct\SpeedexVoucher
     */
    public function setPdf($pdf = null)
    {
        // validation for constraint: string
        if (!is_null($pdf) && !is_string($pdf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pdf, true), gettype($pdf)), __LINE__);
        }
        $this->pdf = $pdf;
        return $this;
    }
    /**
     * Get VoucherID value
     * @return string|null
     */
    public function getVoucherID()
    {
        return $this->VoucherID;
    }
    /**
     * Set VoucherID value
     * @param string $voucherID
     * @return \Speedex\SpeedexStruct\SpeedexVoucher
     */
    public function setVoucherID($voucherID = null)
    {
        // validation for constraint: string
        if (!is_null($voucherID) && !is_string($voucherID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherID, true), gettype($voucherID)), __LINE__);
        }
        $this->VoucherID = $voucherID;
        return $this;
    }
}
