<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLastCheckpoint SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexGetLastCheckpoint extends AbstractStructBase
{
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sessionID;
    /**
     * The VoucherID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VoucherID;
    /**
     * Constructor method for GetLastCheckpoint
     * @uses SpeedexGetLastCheckpoint::setSessionID()
     * @uses SpeedexGetLastCheckpoint::setVoucherID()
     * @param string $sessionID
     * @param string $voucherID
     */
    public function __construct($sessionID = null, $voucherID = null)
    {
        $this
            ->setSessionID($sessionID)
            ->setVoucherID($voucherID);
    }
    /**
     * Get sessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->sessionID;
    }
    /**
     * Set sessionID value
     * @param string $sessionID
     * @return \Speedex\SpeedexStruct\SpeedexGetLastCheckpoint
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionID, true), gettype($sessionID)), __LINE__);
        }
        $this->sessionID = $sessionID;
        return $this;
    }
    /**
     * Get VoucherID value
     * @return string|null
     */
    public function getVoucherID()
    {
        return $this->VoucherID;
    }
    /**
     * Set VoucherID value
     * @param string $voucherID
     * @return \Speedex\SpeedexStruct\SpeedexGetLastCheckpoint
     */
    public function setVoucherID($voucherID = null)
    {
        // validation for constraint: string
        if (!is_null($voucherID) && !is_string($voucherID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherID, true), gettype($voucherID)), __LINE__);
        }
        $this->VoucherID = $voucherID;
        return $this;
    }
}
