<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBranches SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexGetBranches extends AbstractStructBase
{
    /**
     * The language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $language;
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sessionID;
    /**
     * The zipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $zipCode;
    /**
     * The area
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $area;
    /**
     * Constructor method for GetBranches
     * @uses SpeedexGetBranches::setLanguage()
     * @uses SpeedexGetBranches::setSessionID()
     * @uses SpeedexGetBranches::setZipCode()
     * @uses SpeedexGetBranches::setArea()
     * @param int $language
     * @param string $sessionID
     * @param string $zipCode
     * @param string $area
     */
    public function __construct($language = null, $sessionID = null, $zipCode = null, $area = null)
    {
        $this
            ->setLanguage($language)
            ->setSessionID($sessionID)
            ->setZipCode($zipCode)
            ->setArea($area);
    }
    /**
     * Get language value
     * @return int
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param int $language
     * @return \Speedex\SpeedexStruct\SpeedexGetBranches
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: int
        if (!is_null($language) && !(is_int($language) || ctype_digit($language))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get sessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->sessionID;
    }
    /**
     * Set sessionID value
     * @param string $sessionID
     * @return \Speedex\SpeedexStruct\SpeedexGetBranches
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionID, true), gettype($sessionID)), __LINE__);
        }
        $this->sessionID = $sessionID;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return \Speedex\SpeedexStruct\SpeedexGetBranches
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Get area value
     * @return string|null
     */
    public function getArea()
    {
        return $this->area;
    }
    /**
     * Set area value
     * @param string $area
     * @return \Speedex\SpeedexStruct\SpeedexGetBranches
     */
    public function setArea($area = null)
    {
        // validation for constraint: string
        if (!is_null($area) && !is_string($area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($area, true), gettype($area)), __LINE__);
        }
        $this->area = $area;
        return $this;
    }
}
