<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://spdxws.gr/accesspoint.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://spdxws.gr/accesspoint.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Speedex\SpeedexClassMap::get(),
);
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \Speedex\SpeedexService\SpeedexCancel($options);
/**
 * Sample call for CancelBOL operation/method
 */
if ($cancel->CancelBOL(new \Speedex\SpeedexStruct\SpeedexCancelBOL()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for CancelBOLandOrder operation/method
 */
if ($cancel->CancelBOLandOrder(new \Speedex\SpeedexStruct\SpeedexCancelBOLandOrder()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for CancelPickup operation/method
 */
if ($cancel->CancelPickup(new \Speedex\SpeedexStruct\SpeedexCancelPickup()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \Speedex\SpeedexService\SpeedexCreate($options);
/**
 * Sample call for CreateBOL operation/method
 */
if ($create->CreateBOL(new \Speedex\SpeedexStruct\SpeedexCreateBOL()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateBOLwithOrder operation/method
 */
if ($create->CreateBOLwithOrder(new \Speedex\SpeedexStruct\SpeedexCreateBOLwithOrder()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateReturnBOLwithOrder operation/method
 */
if ($create->CreateReturnBOLwithOrder(new \Speedex\SpeedexStruct\SpeedexCreateReturnBOLwithOrder()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateSession operation/method
 */
if ($create->CreateSession(new \Speedex\SpeedexStruct\SpeedexCreateSession()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePickup operation/method
 */
if ($create->CreatePickup(new \Speedex\SpeedexStruct\SpeedexCreatePickup()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePUOrdersforReturn operation/method
 */
if ($create->CreatePUOrdersforReturn(new \Speedex\SpeedexStruct\SpeedexCreatePUOrdersforReturn()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePickupOrder operation/method
 */
if ($create->CreatePickupOrder(new \Speedex\SpeedexStruct\SpeedexCreatePickupOrder()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \Speedex\SpeedexService\SpeedexGet($options);
/**
 * Sample call for GetBOLPdf operation/method
 */
if ($get->GetBOLPdf(new \Speedex\SpeedexStruct\SpeedexGetBOLPdf()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBOLSummaryPdf operation/method
 */
if ($get->GetBOLSummaryPdf(new \Speedex\SpeedexStruct\SpeedexGetBOLSummaryPdf()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBranches operation/method
 */
if ($get->GetBranches(new \Speedex\SpeedexStruct\SpeedexGetBranches()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLastCheckpoint operation/method
 */
if ($get->GetLastCheckpoint(new \Speedex\SpeedexStruct\SpeedexGetLastCheckpoint()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrderLastCheckpoint operation/method
 */
if ($get->GetOrderLastCheckpoint(new \Speedex\SpeedexStruct\SpeedexGetOrderLastCheckpoint()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTraceByClientKey operation/method
 */
if ($get->GetTraceByClientKey(new \Speedex\SpeedexStruct\SpeedexGetTraceByClientKey()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTraceByDate operation/method
 */
if ($get->GetTraceByDate(new \Speedex\SpeedexStruct\SpeedexGetTraceByDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTraceByVoucher operation/method
 */
if ($get->GetTraceByVoucher(new \Speedex\SpeedexStruct\SpeedexGetTraceByVoucher()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTraceByPickup operation/method
 */
if ($get->GetTraceByPickup(new \Speedex\SpeedexStruct\SpeedexGetTraceByPickup()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCODByVoucher operation/method
 */
if ($get->GetCODByVoucher(new \Speedex\SpeedexStruct\SpeedexGetCODByVoucher()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVoucherFromCustomerKey operation/method
 */
if ($get->GetVoucherFromCustomerKey(new \Speedex\SpeedexStruct\SpeedexGetVoucherFromCustomerKey()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVoucherPOD operation/method
 */
if ($get->GetVoucherPOD(new \Speedex\SpeedexStruct\SpeedexGetVoucherPOD()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetConsignmentsByDate operation/method
 */
if ($get->GetConsignmentsByDate(new \Speedex\SpeedexStruct\SpeedexGetConsignmentsByDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDepositedConsignmentsByDate operation/method
 */
if ($get->GetDepositedConsignmentsByDate(new \Speedex\SpeedexStruct\SpeedexGetDepositedConsignmentsByDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPickup operation/method
 */
if ($get->GetPickup(new \Speedex\SpeedexStruct\SpeedexGetPickup()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTraceByVoucherCOSMOTE operation/method
 */
if ($get->GetTraceByVoucherCOSMOTE(new \Speedex\SpeedexStruct\SpeedexGetTraceByVoucherCOSMOTE()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Destroy ServiceType
 */
$destroy = new \Speedex\SpeedexService\SpeedexDestroy($options);
/**
 * Sample call for DestroySession operation/method
 */
if ($destroy->DestroySession(new \Speedex\SpeedexStruct\SpeedexDestroySession()) !== false) {
    print_r($destroy->getResult());
} else {
    print_r($destroy->getLastError());
}
/**
 * Samples for Reschedule ServiceType
 */
$reschedule = new \Speedex\SpeedexService\SpeedexReschedule($options);
/**
 * Sample call for ReschedulePickup operation/method
 */
if ($reschedule->ReschedulePickup(new \Speedex\SpeedexStruct\SpeedexReschedulePickup()) !== false) {
    print_r($reschedule->getResult());
} else {
    print_r($reschedule->getLastError());
}
