<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReschedulePickup SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexReschedulePickup extends AbstractStructBase
{
    /**
     * The pickupDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pickupDate;
    /**
     * The pickupTimeFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pickupTimeFrom;
    /**
     * The pickupTimeTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pickupTimeTo;
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sessionID;
    /**
     * The pickupCustomerComments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pickupCustomerComments;
    /**
     * The pickupNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pickupNumber;
    /**
     * Constructor method for ReschedulePickup
     * @uses SpeedexReschedulePickup::setPickupDate()
     * @uses SpeedexReschedulePickup::setPickupTimeFrom()
     * @uses SpeedexReschedulePickup::setPickupTimeTo()
     * @uses SpeedexReschedulePickup::setSessionID()
     * @uses SpeedexReschedulePickup::setPickupCustomerComments()
     * @uses SpeedexReschedulePickup::setPickupNumber()
     * @param string $pickupDate
     * @param string $pickupTimeFrom
     * @param string $pickupTimeTo
     * @param string $sessionID
     * @param string $pickupCustomerComments
     * @param string $pickupNumber
     */
    public function __construct($pickupDate = null, $pickupTimeFrom = null, $pickupTimeTo = null, $sessionID = null, $pickupCustomerComments = null, $pickupNumber = null)
    {
        $this
            ->setPickupDate($pickupDate)
            ->setPickupTimeFrom($pickupTimeFrom)
            ->setPickupTimeTo($pickupTimeTo)
            ->setSessionID($sessionID)
            ->setPickupCustomerComments($pickupCustomerComments)
            ->setPickupNumber($pickupNumber);
    }
    /**
     * Get pickupDate value
     * @return string
     */
    public function getPickupDate()
    {
        return $this->pickupDate;
    }
    /**
     * Set pickupDate value
     * @param string $pickupDate
     * @return \Speedex\SpeedexStruct\SpeedexReschedulePickup
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDate, true), gettype($pickupDate)), __LINE__);
        }
        $this->pickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get pickupTimeFrom value
     * @return string
     */
    public function getPickupTimeFrom()
    {
        return $this->pickupTimeFrom;
    }
    /**
     * Set pickupTimeFrom value
     * @param string $pickupTimeFrom
     * @return \Speedex\SpeedexStruct\SpeedexReschedulePickup
     */
    public function setPickupTimeFrom($pickupTimeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($pickupTimeFrom) && !is_string($pickupTimeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupTimeFrom, true), gettype($pickupTimeFrom)), __LINE__);
        }
        $this->pickupTimeFrom = $pickupTimeFrom;
        return $this;
    }
    /**
     * Get pickupTimeTo value
     * @return string
     */
    public function getPickupTimeTo()
    {
        return $this->pickupTimeTo;
    }
    /**
     * Set pickupTimeTo value
     * @param string $pickupTimeTo
     * @return \Speedex\SpeedexStruct\SpeedexReschedulePickup
     */
    public function setPickupTimeTo($pickupTimeTo = null)
    {
        // validation for constraint: string
        if (!is_null($pickupTimeTo) && !is_string($pickupTimeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupTimeTo, true), gettype($pickupTimeTo)), __LINE__);
        }
        $this->pickupTimeTo = $pickupTimeTo;
        return $this;
    }
    /**
     * Get sessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->sessionID;
    }
    /**
     * Set sessionID value
     * @param string $sessionID
     * @return \Speedex\SpeedexStruct\SpeedexReschedulePickup
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionID, true), gettype($sessionID)), __LINE__);
        }
        $this->sessionID = $sessionID;
        return $this;
    }
    /**
     * Get pickupCustomerComments value
     * @return string|null
     */
    public function getPickupCustomerComments()
    {
        return $this->pickupCustomerComments;
    }
    /**
     * Set pickupCustomerComments value
     * @param string $pickupCustomerComments
     * @return \Speedex\SpeedexStruct\SpeedexReschedulePickup
     */
    public function setPickupCustomerComments($pickupCustomerComments = null)
    {
        // validation for constraint: string
        if (!is_null($pickupCustomerComments) && !is_string($pickupCustomerComments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupCustomerComments, true), gettype($pickupCustomerComments)), __LINE__);
        }
        $this->pickupCustomerComments = $pickupCustomerComments;
        return $this;
    }
    /**
     * Get pickupNumber value
     * @return string|null
     */
    public function getPickupNumber()
    {
        return $this->pickupNumber;
    }
    /**
     * Set pickupNumber value
     * @param string $pickupNumber
     * @return \Speedex\SpeedexStruct\SpeedexReschedulePickup
     */
    public function setPickupNumber($pickupNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pickupNumber) && !is_string($pickupNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupNumber, true), gettype($pickupNumber)), __LINE__);
        }
        $this->pickupNumber = $pickupNumber;
        return $this;
    }
}
