<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCODByVoucherResponse SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexGetCODByVoucherResponse extends AbstractStructBase
{
    /**
     * The returnCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $returnCode;
    /**
     * The VoucherCods
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Speedex\SpeedexArray\SpeedexArrayOfVoucherCod
     */
    public $VoucherCods;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for GetCODByVoucherResponse
     * @uses SpeedexGetCODByVoucherResponse::setReturnCode()
     * @uses SpeedexGetCODByVoucherResponse::setVoucherCods()
     * @uses SpeedexGetCODByVoucherResponse::setReturnMessage()
     * @param int $returnCode
     * @param \Speedex\SpeedexArray\SpeedexArrayOfVoucherCod $voucherCods
     * @param string $returnMessage
     */
    public function __construct($returnCode = null, \Speedex\SpeedexArray\SpeedexArrayOfVoucherCod $voucherCods = null, $returnMessage = null)
    {
        $this
            ->setReturnCode($returnCode)
            ->setVoucherCods($voucherCods)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get returnCode value
     * @return int
     */
    public function getReturnCode()
    {
        return $this->returnCode;
    }
    /**
     * Set returnCode value
     * @param int $returnCode
     * @return \Speedex\SpeedexStruct\SpeedexGetCODByVoucherResponse
     */
    public function setReturnCode($returnCode = null)
    {
        // validation for constraint: int
        if (!is_null($returnCode) && !(is_int($returnCode) || ctype_digit($returnCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($returnCode, true), gettype($returnCode)), __LINE__);
        }
        $this->returnCode = $returnCode;
        return $this;
    }
    /**
     * Get VoucherCods value
     * @return \Speedex\SpeedexArray\SpeedexArrayOfVoucherCod|null
     */
    public function getVoucherCods()
    {
        return $this->VoucherCods;
    }
    /**
     * Set VoucherCods value
     * @param \Speedex\SpeedexArray\SpeedexArrayOfVoucherCod $voucherCods
     * @return \Speedex\SpeedexStruct\SpeedexGetCODByVoucherResponse
     */
    public function setVoucherCods(\Speedex\SpeedexArray\SpeedexArrayOfVoucherCod $voucherCods = null)
    {
        $this->VoucherCods = $voucherCods;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \Speedex\SpeedexStruct\SpeedexGetCODByVoucherResponse
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
