<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePickupOrder SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexCreatePickupOrder extends AbstractStructBase
{
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sessionID;
    /**
     * The pickupOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Speedex\SpeedexStruct\SpeedexPickupOrder
     */
    public $pickupOrder;
    /**
     * Constructor method for CreatePickupOrder
     * @uses SpeedexCreatePickupOrder::setSessionID()
     * @uses SpeedexCreatePickupOrder::setPickupOrder()
     * @param string $sessionID
     * @param \Speedex\SpeedexStruct\SpeedexPickupOrder $pickupOrder
     */
    public function __construct($sessionID = null, \Speedex\SpeedexStruct\SpeedexPickupOrder $pickupOrder = null)
    {
        $this
            ->setSessionID($sessionID)
            ->setPickupOrder($pickupOrder);
    }
    /**
     * Get sessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->sessionID;
    }
    /**
     * Set sessionID value
     * @param string $sessionID
     * @return \Speedex\SpeedexStruct\SpeedexCreatePickupOrder
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionID, true), gettype($sessionID)), __LINE__);
        }
        $this->sessionID = $sessionID;
        return $this;
    }
    /**
     * Get pickupOrder value
     * @return \Speedex\SpeedexStruct\SpeedexPickupOrder|null
     */
    public function getPickupOrder()
    {
        return $this->pickupOrder;
    }
    /**
     * Set pickupOrder value
     * @param \Speedex\SpeedexStruct\SpeedexPickupOrder $pickupOrder
     * @return \Speedex\SpeedexStruct\SpeedexCreatePickupOrder
     */
    public function setPickupOrder(\Speedex\SpeedexStruct\SpeedexPickupOrder $pickupOrder = null)
    {
        $this->pickupOrder = $pickupOrder;
        return $this;
    }
}
