<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckpointList SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexCheckpointList extends AbstractStructBase
{
    /**
     * The StatusCounter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCounter;
    /**
     * The CheckpointItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Speedex\SpeedexArray\SpeedexArrayOfCheckpoint
     */
    public $CheckpointItems;
    /**
     * Constructor method for CheckpointList
     * @uses SpeedexCheckpointList::setStatusCounter()
     * @uses SpeedexCheckpointList::setCheckpointItems()
     * @param string $statusCounter
     * @param \Speedex\SpeedexArray\SpeedexArrayOfCheckpoint $checkpointItems
     */
    public function __construct($statusCounter = null, \Speedex\SpeedexArray\SpeedexArrayOfCheckpoint $checkpointItems = null)
    {
        $this
            ->setStatusCounter($statusCounter)
            ->setCheckpointItems($checkpointItems);
    }
    /**
     * Get StatusCounter value
     * @return string|null
     */
    public function getStatusCounter()
    {
        return $this->StatusCounter;
    }
    /**
     * Set StatusCounter value
     * @param string $statusCounter
     * @return \Speedex\SpeedexStruct\SpeedexCheckpointList
     */
    public function setStatusCounter($statusCounter = null)
    {
        // validation for constraint: string
        if (!is_null($statusCounter) && !is_string($statusCounter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCounter, true), gettype($statusCounter)), __LINE__);
        }
        $this->StatusCounter = $statusCounter;
        return $this;
    }
    /**
     * Get CheckpointItems value
     * @return \Speedex\SpeedexArray\SpeedexArrayOfCheckpoint|null
     */
    public function getCheckpointItems()
    {
        return $this->CheckpointItems;
    }
    /**
     * Set CheckpointItems value
     * @param \Speedex\SpeedexArray\SpeedexArrayOfCheckpoint $checkpointItems
     * @return \Speedex\SpeedexStruct\SpeedexCheckpointList
     */
    public function setCheckpointItems(\Speedex\SpeedexArray\SpeedexArrayOfCheckpoint $checkpointItems = null)
    {
        $this->CheckpointItems = $checkpointItems;
        return $this;
    }
}
