<?php

namespace Speedex\SpeedexService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create SpeedexService
 * @package Speedex
 * @subpackage Services
 */
class SpeedexCreate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateBOL
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexCreateBOL $parameters
     * @return \Speedex\SpeedexStruct\SpeedexCreateBOLResponse|bool
     */
    public function CreateBOL(\Speedex\SpeedexStruct\SpeedexCreateBOL $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateBOL($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateBOLwithOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexCreateBOLwithOrder $parameters
     * @return \Speedex\SpeedexStruct\SpeedexCreateBOLwithOrderResponse|bool
     */
    public function CreateBOLwithOrder(\Speedex\SpeedexStruct\SpeedexCreateBOLwithOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateBOLwithOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateReturnBOLwithOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexCreateReturnBOLwithOrder $parameters
     * @return \Speedex\SpeedexStruct\SpeedexCreateReturnBOLwithOrderResponse|bool
     */
    public function CreateReturnBOLwithOrder(\Speedex\SpeedexStruct\SpeedexCreateReturnBOLwithOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateReturnBOLwithOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateSession
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexCreateSession $parameters
     * @return \Speedex\SpeedexStruct\SpeedexCreateSessionResponse|bool
     */
    public function CreateSession(\Speedex\SpeedexStruct\SpeedexCreateSession $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateSession($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexCreatePickup $parameters
     * @return \Speedex\SpeedexStruct\SpeedexCreatePickupResponse|bool
     */
    public function CreatePickup(\Speedex\SpeedexStruct\SpeedexCreatePickup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreatePickup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePUOrdersforReturn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexCreatePUOrdersforReturn $parameters
     * @return \Speedex\SpeedexStruct\SpeedexCreatePUOrdersforReturnResponse|bool
     */
    public function CreatePUOrdersforReturn(\Speedex\SpeedexStruct\SpeedexCreatePUOrdersforReturn $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreatePUOrdersforReturn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePickupOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexCreatePickupOrder $parameters
     * @return \Speedex\SpeedexStruct\SpeedexCreatePickupOrderResponse|bool
     */
    public function CreatePickupOrder(\Speedex\SpeedexStruct\SpeedexCreatePickupOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreatePickupOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Speedex\SpeedexStruct\SpeedexCreateBOLResponse|\Speedex\SpeedexStruct\SpeedexCreateBOLwithOrderResponse|\Speedex\SpeedexStruct\SpeedexCreatePickupOrderResponse|\Speedex\SpeedexStruct\SpeedexCreatePickupResponse|\Speedex\SpeedexStruct\SpeedexCreatePUOrdersforReturnResponse|\Speedex\SpeedexStruct\SpeedexCreateReturnBOLwithOrderResponse|\Speedex\SpeedexStruct\SpeedexCreateSessionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
