<?php

namespace CardService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for unblockCardDetails StructType
 * @package CardService
 * @subpackage Structs
 */
class CardServiceUnblockCardDetails extends AbstractStructBase
{
    /**
     * The projectId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $projectId;
    /**
     * The cardType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardType;
    /**
     * The cardSequenceNumber
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardSequenceNumber;
    /**
     * The unblockComment
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $unblockComment;
    /**
     * Constructor method for unblockCardDetails
     * @uses CardServiceUnblockCardDetails::setProjectId()
     * @uses CardServiceUnblockCardDetails::setCardType()
     * @uses CardServiceUnblockCardDetails::setCardSequenceNumber()
     * @uses CardServiceUnblockCardDetails::setUnblockComment()
     * @param string $projectId
     * @param string $cardType
     * @param string $cardSequenceNumber
     * @param string $unblockComment
     */
    public function __construct($projectId = null, $cardType = null, $cardSequenceNumber = null, $unblockComment = null)
    {
        $this
            ->setProjectId($projectId)
            ->setCardType($cardType)
            ->setCardSequenceNumber($cardSequenceNumber)
            ->setUnblockComment($unblockComment);
    }
    /**
     * Get projectId value
     * @return string|null
     */
    public function getProjectId()
    {
        return $this->projectId;
    }
    /**
     * Set projectId value
     * @param string $projectId
     * @return \CardService\StructType\CardServiceUnblockCardDetails
     */
    public function setProjectId($projectId = null)
    {
        // validation for constraint: string
        if (!is_null($projectId) && !is_string($projectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectId)), __LINE__);
        }
        $this->projectId = $projectId;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @param string $cardType
     * @return \CardService\StructType\CardServiceUnblockCardDetails
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get cardSequenceNumber value
     * @return string|null
     */
    public function getCardSequenceNumber()
    {
        return $this->cardSequenceNumber;
    }
    /**
     * Set cardSequenceNumber value
     * @param string $cardSequenceNumber
     * @return \CardService\StructType\CardServiceUnblockCardDetails
     */
    public function setCardSequenceNumber($cardSequenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardSequenceNumber) && !is_string($cardSequenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardSequenceNumber)), __LINE__);
        }
        $this->cardSequenceNumber = $cardSequenceNumber;
        return $this;
    }
    /**
     * Get unblockComment value
     * @return string|null
     */
    public function getUnblockComment()
    {
        return $this->unblockComment;
    }
    /**
     * Set unblockComment value
     * @param string $unblockComment
     * @return \CardService\StructType\CardServiceUnblockCardDetails
     */
    public function setUnblockComment($unblockComment = null)
    {
        // validation for constraint: string
        if (!is_null($unblockComment) && !is_string($unblockComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unblockComment)), __LINE__);
        }
        $this->unblockComment = $unblockComment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CardService\StructType\CardServiceUnblockCardDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
