<?php

namespace CardService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getProjectResponse StructType
 * @package CardService
 * @subpackage Structs
 */
class CardServiceGetProjectResponse extends AbstractStructBase
{
    /**
     * The NumberOfProjects
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $NumberOfProjects;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $Message;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for getProjectResponse
     * @uses CardServiceGetProjectResponse::setNumberOfProjects()
     * @uses CardServiceGetProjectResponse::setMessage()
     * @uses CardServiceGetProjectResponse::setAny()
     * @param string $numberOfProjects
     * @param string $message
     * @param \DOMDocument $any
     */
    public function __construct($numberOfProjects = null, $message = null, \DOMDocument $any = null)
    {
        $this
            ->setNumberOfProjects($numberOfProjects)
            ->setMessage($message)
            ->setAny($any);
    }
    /**
     * Get NumberOfProjects value
     * @return string|null
     */
    public function getNumberOfProjects()
    {
        return $this->NumberOfProjects;
    }
    /**
     * Set NumberOfProjects value
     * @param string $numberOfProjects
     * @return \CardService\StructType\CardServiceGetProjectResponse
     */
    public function setNumberOfProjects($numberOfProjects = null)
    {
        // validation for constraint: string
        if (!is_null($numberOfProjects) && !is_string($numberOfProjects)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberOfProjects)), __LINE__);
        }
        $this->NumberOfProjects = $numberOfProjects;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \CardService\StructType\CardServiceGetProjectResponse
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \CardService\StructType\CardServiceGetProjectResponse::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \CardService\StructType\CardServiceGetProjectResponse
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CardService\StructType\CardServiceGetProjectResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
