<?php

namespace CardService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateCardDetails StructType
 * @package CardService
 * @subpackage Structs
 */
class CardServiceUpdateCardDetails extends AbstractStructBase
{
    /**
     * The projectId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $projectId;
    /**
     * The cardType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardType;
    /**
     * The cardSequenceNumber
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardSequenceNumber;
    /**
     * The FieldNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $FieldNames;
    /**
     * The FieldValues
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $FieldValues;
    /**
     * Constructor method for updateCardDetails
     * @uses CardServiceUpdateCardDetails::setProjectId()
     * @uses CardServiceUpdateCardDetails::setCardType()
     * @uses CardServiceUpdateCardDetails::setCardSequenceNumber()
     * @uses CardServiceUpdateCardDetails::setFieldNames()
     * @uses CardServiceUpdateCardDetails::setFieldValues()
     * @param string $projectId
     * @param string $cardType
     * @param string $cardSequenceNumber
     * @param string[] $fieldNames
     * @param string[] $fieldValues
     */
    public function __construct($projectId = null, $cardType = null, $cardSequenceNumber = null, array $fieldNames = array(), array $fieldValues = array())
    {
        $this
            ->setProjectId($projectId)
            ->setCardType($cardType)
            ->setCardSequenceNumber($cardSequenceNumber)
            ->setFieldNames($fieldNames)
            ->setFieldValues($fieldValues);
    }
    /**
     * Get projectId value
     * @return string|null
     */
    public function getProjectId()
    {
        return $this->projectId;
    }
    /**
     * Set projectId value
     * @param string $projectId
     * @return \CardService\StructType\CardServiceUpdateCardDetails
     */
    public function setProjectId($projectId = null)
    {
        // validation for constraint: string
        if (!is_null($projectId) && !is_string($projectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectId)), __LINE__);
        }
        $this->projectId = $projectId;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @param string $cardType
     * @return \CardService\StructType\CardServiceUpdateCardDetails
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get cardSequenceNumber value
     * @return string|null
     */
    public function getCardSequenceNumber()
    {
        return $this->cardSequenceNumber;
    }
    /**
     * Set cardSequenceNumber value
     * @param string $cardSequenceNumber
     * @return \CardService\StructType\CardServiceUpdateCardDetails
     */
    public function setCardSequenceNumber($cardSequenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardSequenceNumber) && !is_string($cardSequenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardSequenceNumber)), __LINE__);
        }
        $this->cardSequenceNumber = $cardSequenceNumber;
        return $this;
    }
    /**
     * Get FieldNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getFieldNames()
    {
        return isset($this->FieldNames) ? $this->FieldNames : null;
    }
    /**
     * Set FieldNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $fieldNames
     * @return \CardService\StructType\CardServiceUpdateCardDetails
     */
    public function setFieldNames(array $fieldNames = array())
    {
        foreach ($fieldNames as $updateCardDetailsFieldNamesItem) {
            // validation for constraint: itemType
            if (!is_string($updateCardDetailsFieldNamesItem)) {
                throw new \InvalidArgumentException(sprintf('The FieldNames property can only contain items of string, "%s" given', is_object($updateCardDetailsFieldNamesItem) ? get_class($updateCardDetailsFieldNamesItem) : gettype($updateCardDetailsFieldNamesItem)), __LINE__);
            }
        }
        if (is_null($fieldNames) || (is_array($fieldNames) && empty($fieldNames))) {
            unset($this->FieldNames);
        } else {
            $this->FieldNames = $fieldNames;
        }
        return $this;
    }
    /**
     * Add item to FieldNames value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \CardService\StructType\CardServiceUpdateCardDetails
     */
    public function addToFieldNames($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The FieldNames property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FieldNames[] = $item;
        return $this;
    }
    /**
     * Get FieldValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getFieldValues()
    {
        return isset($this->FieldValues) ? $this->FieldValues : null;
    }
    /**
     * Set FieldValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $fieldValues
     * @return \CardService\StructType\CardServiceUpdateCardDetails
     */
    public function setFieldValues(array $fieldValues = array())
    {
        foreach ($fieldValues as $updateCardDetailsFieldValuesItem) {
            // validation for constraint: itemType
            if (!is_string($updateCardDetailsFieldValuesItem)) {
                throw new \InvalidArgumentException(sprintf('The FieldValues property can only contain items of string, "%s" given', is_object($updateCardDetailsFieldValuesItem) ? get_class($updateCardDetailsFieldValuesItem) : gettype($updateCardDetailsFieldValuesItem)), __LINE__);
            }
        }
        if (is_null($fieldValues) || (is_array($fieldValues) && empty($fieldValues))) {
            unset($this->FieldValues);
        } else {
            $this->FieldValues = $fieldValues;
        }
        return $this;
    }
    /**
     * Add item to FieldValues value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \CardService\StructType\CardServiceUpdateCardDetails
     */
    public function addToFieldValues($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The FieldValues property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FieldValues[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CardService\StructType\CardServiceUpdateCardDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
