<?php

namespace CardService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for replyToCommentInput StructType
 * @package CardService
 * @subpackage Structs
 */
class CardServiceReplyToCommentInput extends AbstractStructBase
{
    /**
     * The projectId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $projectId;
    /**
     * The cardType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardType;
    /**
     * The cardId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardId;
    /**
     * The commentExternalId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $commentExternalId;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $comment;
    /**
     * The commentBy
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $commentBy;
    /**
     * Constructor method for replyToCommentInput
     * @uses CardServiceReplyToCommentInput::setProjectId()
     * @uses CardServiceReplyToCommentInput::setCardType()
     * @uses CardServiceReplyToCommentInput::setCardId()
     * @uses CardServiceReplyToCommentInput::setCommentExternalId()
     * @uses CardServiceReplyToCommentInput::setComment()
     * @uses CardServiceReplyToCommentInput::setCommentBy()
     * @param string $projectId
     * @param string $cardType
     * @param string $cardId
     * @param string $commentExternalId
     * @param string $comment
     * @param string $commentBy
     */
    public function __construct($projectId = null, $cardType = null, $cardId = null, $commentExternalId = null, $comment = null, $commentBy = null)
    {
        $this
            ->setProjectId($projectId)
            ->setCardType($cardType)
            ->setCardId($cardId)
            ->setCommentExternalId($commentExternalId)
            ->setComment($comment)
            ->setCommentBy($commentBy);
    }
    /**
     * Get projectId value
     * @return string|null
     */
    public function getProjectId()
    {
        return $this->projectId;
    }
    /**
     * Set projectId value
     * @param string $projectId
     * @return \CardService\StructType\CardServiceReplyToCommentInput
     */
    public function setProjectId($projectId = null)
    {
        // validation for constraint: string
        if (!is_null($projectId) && !is_string($projectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectId)), __LINE__);
        }
        $this->projectId = $projectId;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @param string $cardType
     * @return \CardService\StructType\CardServiceReplyToCommentInput
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get cardId value
     * @return string|null
     */
    public function getCardId()
    {
        return $this->cardId;
    }
    /**
     * Set cardId value
     * @param string $cardId
     * @return \CardService\StructType\CardServiceReplyToCommentInput
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: string
        if (!is_null($cardId) && !is_string($cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardId)), __LINE__);
        }
        $this->cardId = $cardId;
        return $this;
    }
    /**
     * Get commentExternalId value
     * @return string|null
     */
    public function getCommentExternalId()
    {
        return $this->commentExternalId;
    }
    /**
     * Set commentExternalId value
     * @param string $commentExternalId
     * @return \CardService\StructType\CardServiceReplyToCommentInput
     */
    public function setCommentExternalId($commentExternalId = null)
    {
        // validation for constraint: string
        if (!is_null($commentExternalId) && !is_string($commentExternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commentExternalId)), __LINE__);
        }
        $this->commentExternalId = $commentExternalId;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \CardService\StructType\CardServiceReplyToCommentInput
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get commentBy value
     * @return string|null
     */
    public function getCommentBy()
    {
        return $this->commentBy;
    }
    /**
     * Set commentBy value
     * @param string $commentBy
     * @return \CardService\StructType\CardServiceReplyToCommentInput
     */
    public function setCommentBy($commentBy = null)
    {
        // validation for constraint: string
        if (!is_null($commentBy) && !is_string($commentBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commentBy)), __LINE__);
        }
        $this->commentBy = $commentBy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CardService\StructType\CardServiceReplyToCommentInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
