<?php

namespace CardService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Move ServiceType
 * @package CardService
 * @subpackage Services
 */
class CardServiceMove extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named moveCardToBacklog
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CardService\StructType\CardServiceMoveCardToBacklogDetails $part1
     * @return \CardService\StructType\CardServiceMoveCardToBacklogResponse|bool
     */
    public function moveCardToBacklog(\CardService\StructType\CardServiceMoveCardToBacklogDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->moveCardToBacklog($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CardService\StructType\CardServiceMoveCardToBacklogResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
