<?php

namespace CardService;

/**
 * Class which returns the class map definition
 * @package CardService
 */
class CardServiceClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'getProjectResponse' => '\\CardService\\StructType\\CardServiceGetProjectResponse',
            'addCardDetails' => '\\CardService\\StructType\\CardServiceAddCardDetails',
            'addCardResponse' => '\\CardService\\StructType\\CardServiceAddCardResponse',
            'updateCardDetails' => '\\CardService\\StructType\\CardServiceUpdateCardDetails',
            'updateCardResponse' => '\\CardService\\StructType\\CardServiceUpdateCardResponse',
            'deleteCardDetails' => '\\CardService\\StructType\\CardServiceDeleteCardDetails',
            'deleteCardResponse' => '\\CardService\\StructType\\CardServiceDeleteCardResponse',
            'archiveCardDetails' => '\\CardService\\StructType\\CardServiceArchiveCardDetails',
            'archiveCardResponse' => '\\CardService\\StructType\\CardServiceArchiveCardResponse',
            'blockCardDetails' => '\\CardService\\StructType\\CardServiceBlockCardDetails',
            'blockCardResponse' => '\\CardService\\StructType\\CardServiceBlockCardResponse',
            'getCardDetails' => '\\CardService\\StructType\\CardServiceGetCardDetails',
            'getCardResponse' => '\\CardService\\StructType\\CardServiceGetCardResponse',
            'moveCardToBacklogDetails' => '\\CardService\\StructType\\CardServiceMoveCardToBacklogDetails',
            'moveCardToBacklogResponse' => '\\CardService\\StructType\\CardServiceMoveCardToBacklogResponse',
            'unblockCardDetails' => '\\CardService\\StructType\\CardServiceUnblockCardDetails',
            'unblockCardResponse' => '\\CardService\\StructType\\CardServiceUnblockCardResponse',
            'addCommentToCardInput' => '\\CardService\\StructType\\CardServiceAddCommentToCardInput',
            'addCommentToCardOutput' => '\\CardService\\StructType\\CardServiceAddCommentToCardOutput',
            'replyToCommentInput' => '\\CardService\\StructType\\CardServiceReplyToCommentInput',
        );
    }
}
