<?php

namespace CardService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addCommentToCardOutput StructType
 * @package CardService
 * @subpackage Structs
 */
class CardServiceAddCommentToCardOutput extends AbstractStructBase
{
    /**
     * The projectId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $projectId;
    /**
     * The cardType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardType;
    /**
     * The cardId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardId;
    /**
     * The commentId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var int
     */
    public $commentId;
    /**
     * Constructor method for addCommentToCardOutput
     * @uses CardServiceAddCommentToCardOutput::setProjectId()
     * @uses CardServiceAddCommentToCardOutput::setCardType()
     * @uses CardServiceAddCommentToCardOutput::setCardId()
     * @uses CardServiceAddCommentToCardOutput::setCommentId()
     * @param string $projectId
     * @param string $cardType
     * @param string $cardId
     * @param int $commentId
     */
    public function __construct($projectId = null, $cardType = null, $cardId = null, $commentId = null)
    {
        $this
            ->setProjectId($projectId)
            ->setCardType($cardType)
            ->setCardId($cardId)
            ->setCommentId($commentId);
    }
    /**
     * Get projectId value
     * @return string|null
     */
    public function getProjectId()
    {
        return $this->projectId;
    }
    /**
     * Set projectId value
     * @param string $projectId
     * @return \CardService\StructType\CardServiceAddCommentToCardOutput
     */
    public function setProjectId($projectId = null)
    {
        // validation for constraint: string
        if (!is_null($projectId) && !is_string($projectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectId)), __LINE__);
        }
        $this->projectId = $projectId;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @param string $cardType
     * @return \CardService\StructType\CardServiceAddCommentToCardOutput
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get cardId value
     * @return string|null
     */
    public function getCardId()
    {
        return $this->cardId;
    }
    /**
     * Set cardId value
     * @param string $cardId
     * @return \CardService\StructType\CardServiceAddCommentToCardOutput
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: string
        if (!is_null($cardId) && !is_string($cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardId)), __LINE__);
        }
        $this->cardId = $cardId;
        return $this;
    }
    /**
     * Get commentId value
     * @return int|null
     */
    public function getCommentId()
    {
        return $this->commentId;
    }
    /**
     * Set commentId value
     * @param int $commentId
     * @return \CardService\StructType\CardServiceAddCommentToCardOutput
     */
    public function setCommentId($commentId = null)
    {
        // validation for constraint: int
        if (!is_null($commentId) && !is_numeric($commentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($commentId)), __LINE__);
        }
        $this->commentId = $commentId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CardService\StructType\CardServiceAddCommentToCardOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
