<?php

namespace CardService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @package CardService
 * @subpackage Services
 */
class CardServiceAdd extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CardService\StructType\CardServiceAddCardDetails $part1
     * @return \CardService\StructType\CardServiceAddCardResponse|bool
     */
    public function addCard(\CardService\StructType\CardServiceAddCardDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->addCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCommentToCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CardService\StructType\CardServiceAddCommentToCardInput $part1
     * @return \CardService\StructType\CardServiceAddCommentToCardOutput|bool
     */
    public function addCommentToCard(\CardService\StructType\CardServiceAddCommentToCardInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->addCommentToCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CardService\StructType\CardServiceAddCardResponse|\CardService\StructType\CardServiceAddCommentToCardOutput
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
