<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \CardService\CardServiceClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \CardService\ServiceType\CardServiceGet($options);
/**
 * Sample call for getProject operation/method
 */
if ($get->getProject($getProjectDetails) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCard operation/method
 */
if ($get->getCard(new \CardService\StructType\CardServiceGetCardDetails()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \CardService\ServiceType\CardServiceAdd($options);
/**
 * Sample call for addCard operation/method
 */
if ($add->addCard(new \CardService\StructType\CardServiceAddCardDetails()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCommentToCard operation/method
 */
if ($add->addCommentToCard(new \CardService\StructType\CardServiceAddCommentToCardInput()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \CardService\ServiceType\CardServiceUpdate($options);
/**
 * Sample call for updateCard operation/method
 */
if ($update->updateCard(new \CardService\StructType\CardServiceUpdateCardDetails()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \CardService\ServiceType\CardServiceDelete($options);
/**
 * Sample call for deleteCard operation/method
 */
if ($delete->deleteCard(new \CardService\StructType\CardServiceDeleteCardDetails()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Archive ServiceType
 */
$archive = new \CardService\ServiceType\CardServiceArchive($options);
/**
 * Sample call for archiveCard operation/method
 */
if ($archive->archiveCard(new \CardService\StructType\CardServiceArchiveCardDetails()) !== false) {
    print_r($archive->getResult());
} else {
    print_r($archive->getLastError());
}
/**
 * Samples for Block ServiceType
 */
$block = new \CardService\ServiceType\CardServiceBlock($options);
/**
 * Sample call for blockCard operation/method
 */
if ($block->blockCard(new \CardService\StructType\CardServiceBlockCardDetails()) !== false) {
    print_r($block->getResult());
} else {
    print_r($block->getLastError());
}
/**
 * Samples for Move ServiceType
 */
$move = new \CardService\ServiceType\CardServiceMove($options);
/**
 * Sample call for moveCardToBacklog operation/method
 */
if ($move->moveCardToBacklog(new \CardService\StructType\CardServiceMoveCardToBacklogDetails()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Samples for Unblock ServiceType
 */
$unblock = new \CardService\ServiceType\CardServiceUnblock($options);
/**
 * Sample call for unblockCard operation/method
 */
if ($unblock->unblockCard(new \CardService\StructType\CardServiceUnblockCardDetails()) !== false) {
    print_r($unblock->getResult());
} else {
    print_r($unblock->getLastError());
}
/**
 * Samples for Reply ServiceType
 */
$reply = new \CardService\ServiceType\CardServiceReply($options);
/**
 * Sample call for replyToComment operation/method
 */
if ($reply->replyToComment(new \CardService\StructType\CardServiceReplyToCommentInput()) !== false) {
    print_r($reply->getResult());
} else {
    print_r($reply->getLastError());
}
